
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Define research funding data for different research topics across institutions
funding_data = np.array([[2, 1.5, 3.5, 4], [1, 2.5, 3, 2.5], [3, 2.2, 4.1, 3.3], [1.8, 2.7, 3.9, 3.1]])

# Define the edges of the bins
topics_edges = np.array([0, 1, 2, 3, 4])
institutions_edges = np.array([0, 1, 2, 3, 4])

# Construct arrays for the anchor positions of the 4 bars.
xpos, ypos = np.meshgrid(topics_edges[:-1] + 0.25, institutions_edges[:-1] + 0.25, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Flatten the funding data and filter non-zero bars
dz = funding_data.ravel()
non_zero_indices = dz > 0
xpos = xpos[non_zero_indices]
ypos = ypos[non_zero_indices]
dz = dz[non_zero_indices]

# All bars have the same width and depth
dx = dy = 0.5 * np.ones_like(dz)

# Axes Limits and Labels
ax_xlabel = "Research Topics"
ax_ylabel = "Institutions"
ax_zlabel = "Funding Amount (in million $)"
chart_title = "Research Funding across Institutions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure for the modified 3D bar plot
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

zticks_values = [0, 1, 2, 3, 4]

# Define a color palette for the bars
colors = plt.cm.viridis(dz / dz.max())

ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors)

# Set axis labels and title
ax.set_xlabel(ax_xlabel, labelpad=10)
ax.set_ylabel(ax_ylabel, labelpad=10)
ax.set_zlabel(ax_zlabel, labelpad=10)
ax.set_title(chart_title, pad=0)

# Set z-axis ticks
ax.set_zticks(zticks_values)

ax.set_box_aspect(aspect=None, zoom=0.8)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_49.pdf", bbox_inches="tight")
