
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)  # Set seed for reproducibility

# Constructing a custom histogram for transportation data
# Example: Vehicle counts (0-50 scale) at different checkpoints
hist = np.array([[20, 0, 0, 0], [0, 35, 0, 0], [0, 0, 25, 0], [0, 0, 0, 45]])

# Define the edges of the bins
xedges = np.array([0, 1, 2, 3, 4])
yedges = np.array([0, 1, 2, 3, 4])

# Construct arrays for the anchor positions of the bars
xpos, ypos = np.meshgrid(xedges[:-1] + 0.25, yedges[:-1] + 0.25, indexing="ij")
xpos = xpos.ravel()
ypos = ypos.ravel()
zpos = 0

# Only keep positions where there is a non-zero bar
non_zero_indices = hist.ravel() > 0
xpos = xpos[non_zero_indices]
ypos = ypos[non_zero_indices]
dz = hist.ravel()[non_zero_indices]

# All bars have the same width and depth
dx = dy = 0.5 * np.ones_like(dz)

# Axes Limits and Labels
ax_xlabel = "Checkpoint X"
ax_ylabel = "Checkpoint Y"
ax_zlabel = "Vehicle Count"
ax_title = "Vehicle Counts at Different Checkpoints"
ax_suptitle = "Transportation Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a new figure for the 3D bar plot
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Modified zticks values to reflect transportation data levels more meaningfully
zticks_values = [0, 10, 20, 30, 40, 50]

# Color scheme: shades of green and blue
colors = ["#4CAF50", "#8BC34A", "#2196F3", "#03A9F4"]

ax.bar3d(xpos, ypos, zpos, dx, dy, dz, zsort="average", color=colors)

# Setting the labels and title
ax.set_xlabel(ax_xlabel)
ax.set_ylabel(ax_ylabel)
ax.set_zlabel(ax_zlabel)
ax.set_title(ax_title)
plt.suptitle(ax_suptitle)

# Setting zticks
ax.set_zticks(zticks_values)

# Adjusting aspect ratio and zoom
ax.set_box_aspect(aspect=[1, 1, 1], zoom=0.95)

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_50.pdf", bbox_inches="tight")

