

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Labels and Titles
xlabel = 'Date'
ylabel = 'Field Position'
zlabel = 'Soil Moisture (%)'
title = '3D Soil Moisture Distribution Over Time'
legendlabel = 'Moisture Surface'

# Generate new data suitable for the agriculture domain
np.random.seed(42)
dates = np.linspace(0, 365, 100)  # Simulating one year of data
positions = np.linspace(0, 100, 100)  # Positions in the field
dates, positions = np.meshgrid(dates, positions)
soil_moisture = 20 + 10 * np.sin(dates * 2 * np.pi / 365) * np.cos(positions * 2 * np.pi / 100)  # Mock soil moisture data

# Ensuring the data is reshaped correctly for the 3D plot
x, y = np.meshgrid(dates[0], positions[:, 0])

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(projection="3d")

# Plot the surface with a new color scheme
surf = ax.plot_surface(x, y, soil_moisture, cmap='viridis', edgecolor='none')

# Adding color bar for reference
fig.colorbar(surf, shrink=0.5, aspect=5, label=zlabel)

# Set axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Set chart title
ax.set_title(title)

# Setting ticks for better readability
ax.set_xticks(np.linspace(dates.min(), dates.max(), 5))
ax.set_yticks(np.linspace(positions.min(), positions.max(), 5))
ax.set_zticks(np.linspace(soil_moisture.min(), soil_moisture.max(), 5))

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("3d_52.pdf", bbox_inches="tight")

