

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Independent variables
hours_study = np.array([1, 2, 3, 4, 5, 6, 7, 8, 9, 10])
faith_level = np.array([30, 35, 40, 45, 50, 55, 60, 65, 70, 75])
# Dependent variable (community engagement score)
engagement_score = np.array([20, 25, 30, 35, 40, 50, 60, 65, 70, 75])
engagement_score_fit = np.polyval(np.polyfit(hours_study, engagement_score, 1), hours_study)

# Labels
xlabel = "Hours of Religious Study"
ylabel = "Level of Faith"
zlabel = "Community Engagement Score"
labels = ["Observed Engagement Scores", "Fitted Engagement Trend"]
title ="Relationship Between Study, Faith, and Engagement"
suptitle = "Religious Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 8))
ax = fig.add_subplot(111, projection="3d")

# Scatter plot
ax.scatter(hours_study, faith_level, engagement_score, color="#FF6347", label=labels[0], marker="^")

# Fit line
ax.plot(hours_study, faith_level, engagement_score_fit, color="#4682B4", label=labels[1], linestyle='--', linewidth=2)

# Setting axis labels
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)

# Customizing legend
ax.legend()

# Box aspect and zoom adjustments
ax.set_box_aspect(aspect=[2, 1, 1])

# Title and additional style enhancements
ax.set_title(title, fontsize=14, fontweight='bold')
fig.suptitle(suptitle, fontsize=16, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_56.pdf", bbox_inches="tight")
