

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(1)  # Set seed for reproducibility
yticklabels = ["Wheat", "Corn"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
wheat_yield = np.array([2.5, 2.7, 2.9, 3.1, 3.3, 3.4, 3.6, 3.7, 3.8, 4.0])
corn_yield = np.array([3.0, 3.2, 3.3, 3.5, 3.7, 4.0, 4.2, 4.3, 4.5, 4.7])
xlabel = "Year"
ylabel = "Crop Type"
zlabel = "Yield (tons/acre)"
title = "Crop Yield Over Years"
legend_labels = ["Wheat", "Corn"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Customize bar colors
wheat_color = "coral"
corn_color = "darkturquoise"

# Plot bars
ax.bar(years, wheat_yield, zs=0, zdir="y", color=wheat_color, alpha=0.8)
ax.bar(years, corn_yield, zs=1, zdir="y", color=corn_color, alpha=0.8)

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_zlabel(zlabel)
ax.set_title(title)

# Set y-ticks and labels
ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels)

# Add a legend
ax.legend(legend_labels, loc='upper left', bbox_to_anchor=(0.05, 0.95))

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_58.pdf", bbox_inches="tight")

