
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
yticklabels = ["Printed Books", "E-Books"]
years = np.array([2010, 2011, 2012, 2013, 2014, 2015, 2016, 2017, 2018, 2019])
printed_books = np.array([800, 780, 760, 740, 720, 700, 680, 660, 640, 620])
e_books = np.array([50, 100, 150, 200, 300, 400, 500, 600, 700, 800])
xlabel = "Year"
ylabel = "Book Format"
zlabel = "Number of Books Published"
chart_title = "Books Published by Format (2010-2019)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig = plt.figure(figsize=(10, 7))
ax = fig.add_subplot(projection="3d")

# Colors for the bars
color_printed_books = "lightcoral"
color_e_books = "mediumseagreen"

ax.bar(years, printed_books, zs=0, zdir="y", color=color_printed_books, alpha=0.8, width=0.8)
ax.bar(years, e_books, zs=1, zdir="y", color=color_e_books, alpha=0.8, width=0.8)

ax.set_xlabel(xlabel, fontsize=12, labelpad=10)
ax.set_ylabel(ylabel, fontsize=12, labelpad=0)
ax.set_zlabel(zlabel, fontsize=12, labelpad=10)
ax.set_title(chart_title, fontsize=14, pad=20)

ax.set_yticks([0, 1])
ax.set_yticklabels(yticklabels, fontsize=12, rotation=10)
ax.view_init(elev=20., azim=-60)

# Add grid
ax.grid(True, linestyle='--', linewidth=0.5)

# Add legend
ax.legend(['Printed Books', 'E-Books'], loc='upper left', fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_59.pdf", bbox_inches="tight")
