

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Generate data for stock market (stock prices, trading volume, and volatility)
np.random.seed(42)

# Stock A data (price in USD)
stock_a_price = np.random.normal(
    loc=100, scale=10, size=50
)  # mean price around $100

# Stock A trading volume (in millions)
stock_a_volume = np.random.uniform(
    low=1, high=10, size=50
)  # randomly between 1M and 10M shares

# Stock A volatility (percentage)
stock_a_volatility = np.random.normal(
    loc=5, scale=1.5, size=50
)  # mean volatility around 5%

# Stock B data for variations in different conditions
stock_b_price = np.random.normal(loc=150, scale=15, size=50)
stock_b_volume = np.random.uniform(low=2, high=12, size=50)
stock_b_volatility = np.random.normal(loc=7, scale=2, size=50)

labels = ["Stock A", "Stock B"]
xlabel = "Stock Price (USD)"
ylabel = "Trading Volume (Millions)"
zlabel = "Volatility (%)"
title = "3D Stock Market Data Visualization"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
fig, ax = plt.subplots(figsize=(10, 7), subplot_kw={"projection": "3d"})

# Configure the plot limits
ax.set_xlim3d([70, 180])
ax.set_ylim3d([0, 15])
ax.set_zlim3d([0, 12])

# Set the viewing angle
ax.view_init(elev=30, azim=70)
ax.dist = 10

# Scatter plot for the first set of data
ax.scatter3D(stock_a_price, stock_a_volume, stock_a_volatility, color="#1f77b4", marker="o", label=labels[0])

# Scatter plot for the second set of data
ax.scatter3D(stock_b_price, stock_b_volume, stock_b_volatility, color="#ff7f0e", marker="^", label=labels[1])

# Modify axis labels and title
ax.set_xlabel(xlabel, fontsize=12)
ax.set_ylabel(ylabel, fontsize=12)
ax.set_zlabel(zlabel, fontsize=12)
ax.set_title(title, fontsize=15)

# Legend for the plot
plt.legend(loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("3d_68.pdf", bbox_inches="tight")

