

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
# Importing numpy
import numpy as np

# Set a random seed for reproducibility
np.random.seed(42)
Time = np.linspace(0, 12, 100)  # Time in months
Geo = np.linspace(0, 100, 100)  # Spatial coordinate
Time, Geo = np.meshgrid(Time, Geo)
Temp1 = 10 + 10*np.sin(Time/2) * np.cos(Geo/50)  # Temperature variations for region 1
Temp2 = 15 + 5*np.cos(Time/2) * np.sin(Geo/50)  # Temperature variations for region 2

# Titles and labels
title1 = "Temperature Variation in Region 1"
title2 = "Temperature Variation in Region 2"
xlabel = "Time (months)"
ylabel = "Geographical Coordinate"
zlabel = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig, axs = plt.subplots(1, 2, figsize=(14, 6), subplot_kw={"projection": "3d"})

# First subplot
cmap1 = "viridis"
axs[0].plot_surface(Time, Geo, Temp1, cmap=cmap1, edgecolor="none", alpha=0.85)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].set_zlabel(zlabel)

# Second subplot
cmap2 = "plasma"
axs[1].plot_surface(Time, Geo, Temp2, cmap=cmap2, edgecolor="none", alpha=0.85)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].set_zlabel(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_69.pdf", bbox_inches="tight")

