
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
# Import numpy for data generation
import numpy as np

# Simulate temperature data
np.random.seed(42)
time = np.linspace(0, 24, 100)  # Simulating temperature changes over a day (24 hours)
temp1 = 20 + 5 * np.sin(time / 3) + np.random.randn(100)  # Temp at location 1
temp2 = 18 + 4 * np.sin(time / 4) + np.random.randn(100)  # Temp at location 2

# Data for plotting
X, Y = np.meshgrid(time, time)
Z1 = np.outer(temp1, np.ones_like(temp1))
Z2 = np.outer(temp2, np.ones_like(temp2))

# Titles and labels
title1 = "Temperature Fluctuation at Location 1"
title2 = "Temperature Fluctuation at Location 2"
xlabel = "Time (hours)"
ylabel = "Time (hours)"
zlabel = "Temperature (°C)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure with specified size
fig, axs = plt.subplots(1, 2, figsize=(14, 6), subplot_kw={"projection": "3d"})

# First subplot
axs[0].plot_surface(X, Y, Z1, cmap="Greens", edgecolor="none", alpha=0.85)
axs[0].set_title(title1)
axs[0].set_xlabel(xlabel)
axs[0].set_ylabel(ylabel)
axs[0].set_zlabel(zlabel)

# Second subplot
axs[1].plot_surface(X, Y, Z2, cmap="Reds", edgecolor="none", alpha=0.85)
axs[1].set_title(title2)
axs[1].set_xlabel(xlabel)
axs[1].set_ylabel(ylabel)
axs[1].set_zlabel(zlabel)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the figure
plt.tight_layout()
plt.savefig("3d_71.pdf", bbox_inches="tight")
