
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.collections import PolyCollection
from mpl_toolkits.mplot3d import Axes3D

# ===================
# Part 2: Data Preparation
# ===================
# Set a random seed for reproducibility
import numpy as np
np.random.seed(0)

# Function to create polygon under graph
def polygon_under_graph(x, y):
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

# Data for bar chart
survey_years = [2000, 2001, 2002, 2003, 2004, 2005, 2006, 2007, 2008, 2009]
religion_A = [45, 47, 50, 52, 55, 58, 60, 63, 65, 70]
religion_B = [30, 32, 33, 34, 35, 37, 38, 40, 42, 45]

# Data for distribution graph
age_groups = np.linspace(10, 60, 31)
religious_activities = range(1, 3)  # Two activities
exp = np.exp
verts = [polygon_under_graph(age_groups, exp(-0.1 * (age_groups - t * 10) ** 2)) for t in religious_activities]

# Labels and titles
xlabel_bar_chart = "Survey Year"
ylabel_bar_chart = "Religion"
zlabel_bar_chart = "Affiliation Percentage"
yticks_bar_chart = [0, 1]
yticklabels_bar_chart = ["Religion A", "Religion B"]
title_bar_chart = "Religious Affiliation Over Time"

xlabel_dist_graph = "Age Group"
ylabel_dist_graph = "Activity Type"
zlabel_dist_graph = "Engagement Rate"
yticks_dist_graph = [1, 2]
title_dist_graph = "Religious Activity Engagement by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize figure and axes
facecolors = plt.get_cmap("viridis")(np.linspace(0, 1, len(verts)))
fig = plt.figure(figsize=(15, 10))
ax1 = fig.add_subplot(121, projection="3d")  # 3D bar chart
ax2 = fig.add_subplot(122, projection="3d")  # 3D distribution graph

# Plot data for bar chart
ax1.bar(survey_years, religion_A, zs=0, zdir="y", color="#1f77b4", alpha=0.8, edgecolor='k')
ax1.bar(survey_years, religion_B, zs=1, zdir="y", color="#ff7f0e", alpha=0.8, edgecolor='k')

# Set labels and ticks for bar chart
ax1.set_xlabel(xlabel_bar_chart)
ax1.set_ylabel(ylabel_bar_chart)
ax1.set_zlabel(zlabel_bar_chart)
ax1.set_yticks(yticks_bar_chart)
ax1.set_yticklabels(yticklabels_bar_chart)
ax1.set_title(title_bar_chart, pad=20, fontweight='bold')

# Add polygons to the distribution graph
poly = PolyCollection(verts, facecolors=facecolors, alpha=0.7, edgecolor='k')
ax2.add_collection3d(poly, zs=religious_activities, zdir="y")

# Set labels and limits for distribution graph
ax2.set(
    xlim=(10, 60),
    ylim=(1, 3),
    zlim=(0, 1),
    xlabel=xlabel_dist_graph,
    ylabel=ylabel_dist_graph,
    zlabel=zlabel_dist_graph,
)
ax2.set_yticks(yticks_dist_graph)
ax2.set_title(title_dist_graph, pad=20, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("3d_75.pdf", bbox_inches="tight")
