

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from matplotlib.collections import PolyCollection

# ===================
# Part 2: Data Preparation
# ===================
# Set a random seed for reproducibility
import numpy as np

np.random.seed(0)

# Function to create polygon under graph
def polygon_under_graph(x, y):
    return [(x[0], 0.0), *zip(x, y), (x[-1], 0.0)]

# Data for bar chart
years = [2015, 2016, 2017, 2018, 2019, 2020, 2021, 2022, 2023, 2024]
basic_subscription = [5, 10, 15, 20, 25, 30, 35, 40, 45, 50]
standard_subscription = [8, 14, 20, 28, 36, 45, 55, 65, 75, 85]
premium_subscription = [2, 4, 8, 12, 18, 24, 32, 40, 50, 60]

# Data for distribution graph
x = np.linspace(0.0, 10.0, 31)
streaming_tech = range(1, 4)
exp = np.exp
verts = [polygon_under_graph(x, exp(-0.5 * (x - t) ** 2)) for t in streaming_tech]  # Gaussian distributions

# Labels and Titles
xlabel_bar_chart = "Year"
ylabel_bar_chart = "Subscription Type"
zlabel_bar_chart = "Number of Subscriptions (Million)"
yticks_bar_chart = [0, 1, 2]
yticklabels_bar_chart = ["Basic", "Standard", "Premium"]
title_bar_chart = "Growth in Streaming Service Subscriptions Over Time"

xlabel_dist_graph = "Years Since Launch"
ylabel_dist_graph = "Streaming Technology"
zlabel_dist_graph = "Adoption Rate"
yticks_dist_graph = [1, 2, 3]
title_dist_graph = "Adoption Rate of Streaming Technologies"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Initialize figure and axes
facecolors = plt.get_cmap("cool")(np.linspace(0, 1, len(verts)))
fig = plt.figure(figsize=(15, 10))
ax1 = fig.add_subplot(121, projection="3d")  # 3D bar chart
ax2 = fig.add_subplot(122, projection="3d")  # 3D distribution graph

# Plot data for bar chart
ax1.bar(years, basic_subscription, zs=0, zdir="y", color="#3498db", alpha=0.8)
ax1.bar(years, standard_subscription, zs=1, zdir="y", color="#2ecc71", alpha=0.8)
ax1.bar(years, premium_subscription, zs=2, zdir="y", color="#e74c3c", alpha=0.8)

# Set labels and ticks for bar chart
ax1.set_xlabel(xlabel_bar_chart)
ax1.set_ylabel(ylabel_bar_chart)
ax1.set_zlabel(zlabel_bar_chart)
ax1.set_yticks(yticks_bar_chart)
ax1.set_yticklabels(yticklabels_bar_chart)
ax1.set_title(title_bar_chart, pad=20)
ax1.tick_params(axis='y', pad=0)

# Add polygons to the distribution graph
poly = PolyCollection(verts, facecolors=facecolors, alpha=0.7)
ax2.add_collection3d(poly, zs=streaming_tech, zdir="y")

# Set labels and limits for distribution graph
ax2.set_xlim((0, 10))
ax2.set_ylim((1, 4))
ax2.set_zlim((0, 1))
ax2.set_xlabel(xlabel_dist_graph)
ax2.set_ylabel(ylabel_dist_graph)
ax2.set_zlabel(zlabel_dist_graph)
ax2.set_yticks(yticks_dist_graph)
ax2.set_title(title_dist_graph, pad=20)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("3d_77.pdf", bbox_inches="tight")

