
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(1)

# Sample data for psychological metrics
x1 = np.linspace(0, 20, 100)    # Low stress levels
y1 = norm.pdf(x1, 10, 2)
x2 = np.linspace(20, 60, 100)   # Medium happiness index
y2 = norm.pdf(x2, 40, 5)
x3 = np.linspace(60, 100, 100)  # High mental well-being
y3 = norm.pdf(x3, 80, 5)
labels = ["Low Stress", "Medium Happiness", "High Well-being"]
xlabel = "Psychological Metric Scores"
ylabel = "Distribution Density"
annotation_texts = ["10 units", "20 units", "15 units"]
title = "Distribution of Psychological Metrics in Population"
legend_labels = ["Low Stress", "Medium Happiness", "High Well-being"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the distributions with customized styles
ax.plot(x1, y1, linestyle='--', linewidth=2, color='#FF6347', label=labels[0])
ax.plot(x2, y2, linestyle='-', linewidth=2, color='#4682B4', label=labels[1])
ax.plot(x3, y3, linestyle=':', linewidth=2, color='#32CD32', label=labels[2])

# Adding histograms with filled colors
ax.hist(np.random.normal(10, 2, 1000), bins=10, density=True, alpha=0.6, color='#FFA07A')
ax.hist(np.random.normal(40, 5, 1000), bins=10, density=True, alpha=0.6, color='#B0E0E6')
ax.hist(np.random.normal(80, 5, 1000), bins=10, density=True, alpha=0.6, color='#98FB98')

# Add annotations
ax.annotate("", xy=(10, 0.13), xytext=(40, 0.13), arrowprops=dict(facecolor="black", arrowstyle="<->"))
ax.annotate("", xy=(10, 0.16), xytext=(80, 0.16), arrowprops=dict(facecolor="black", arrowstyle="<->"))
ax.annotate("", xy=(40, 0.10), xytext=(80, 0.10), arrowprops=dict(facecolor="black", arrowstyle="<->"))

# Text annotations
ax.text(25, 0.131, annotation_texts[0], fontsize=12, ha="center")
ax.text(45, 0.161, annotation_texts[1], fontsize=12, ha="center")
ax.text(60, 0.101, annotation_texts[2], fontsize=12, ha="center")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Adjust y-axis and y-ticks
ax.set_ylim(0.00, 0.20)
ax.set_yticks([0.00, 0.05, 0.10, 0.15, 0.20])
# Adding grid lines
ax.grid(True, linestyle='--', alpha=0.7)

# Add legend
ax.legend(legend_labels, ncol=3)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_100.pdf", bbox_inches="tight")
