
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(42)

# New Sample data: Stress levels across different age groups
x1 = np.linspace(0, 100, 100)
y1 = norm.pdf(x1, 25, 5)  # Teenagers
x2 = np.linspace(0, 100, 100)
y2 = norm.pdf(x2, 50, 10)  # Adults
x3 = np.linspace(0, 100, 100)
y3 = norm.pdf(x3, 70, 8)  # Seniors

# Text Labels
labels = ["Teenagers", "Adults", "Seniors"]
xlabel = "Stress Level"
ylabel = "Density"
annotation_texts = ["25%", "50%", "25%"]
title = "Stress Level Distributions across Age Groups"
legend_labels = [labels[0], labels[1], labels[2]]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot the distributions with new styles
ax.plot(x1, y1, color="skyblue", linestyle='-', linewidth=2, label=labels[0])
ax.plot(x2, y2, color="lightgreen", linestyle='--', linewidth=2, label=labels[1])
ax.plot(x3, y3, color="slategrey", linestyle=':', linewidth=2, label=labels[2])

# Draw histograms
ax.hist(np.random.normal(25, 5, 1000), bins=5, density=True, alpha=0.5, color="lightblue")
ax.hist(np.random.normal(50, 10, 1000), bins=5, density=True, alpha=0.5, color="lightgreen")
ax.hist(np.random.normal(70, 8, 1000), bins=5, density=True, alpha=0.5, color="lightgrey")

# Add annotations
ax.annotate(
    annotation_texts[0],
    xy=(25, 0.07),
    xytext=(40, 0.07),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    annotation_texts[1],
    xy=(25, 0.04),
    xytext=(75, 0.04),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)
ax.annotate(
    annotation_texts[2],
    xy=(50, 0.02),
    xytext=(70, 0.02),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
)

# Add text on corresponding positions
ax.text(32, 0.071, "25%", fontsize=12, ha="center")
ax.text(50, 0.041, "50%", fontsize=12, ha="center")
ax.text(60, 0.021, "25%", fontsize=12, ha="center")

# Set labels and title
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)

# Set y-axis limits and ticks
ax.set_ylim(0.00, 0.08)
ax.set_yticks([0.00, 0.02, 0.04, 0.06, 0.08])

# Add legend
ax.legend(ncol=1)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_101.pdf", bbox_inches="tight")
