
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
from scipy.stats import norm

np.random.seed(0)

# Sample data for demonstration purposes
x1 = np.linspace(0, 14, 100)
y1 = norm.pdf(x1, 7, 2)
x2 = np.linspace(15, 64, 100)
y2 = norm.pdf(x2, 40, 12)
x3 = np.linspace(65, 90, 100)
y3 = norm.pdf(x3, 75, 5)
labels = ["Children", "Adults", "Senior Citizens"]
xlabel = "Age"
ylabel = "Population Density"
annotation_texts = ["Childhood Range", "Adult Range"]
title = "Age Distribution of Population"
supertitle = "Demographic Analysis"
legendlabels = ["Children", "Adults", "Senior Citizens"]
legendtitle="Age Groups"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plot the distributions
ax.plot(x1, y1, color="teal", linestyle="--", linewidth=2, label=labels[0])
ax.plot(x2, y2, color="goldenrod", linestyle="-", linewidth=2, label=labels[1])
ax.plot(x3, y3, color="maroon", linestyle=":", linewidth=2, label=labels[2])

# Draw histograms for each distribution
ax.hist(np.random.normal(7, 2, 1000), bins=10, density=True, alpha=0.5, color="lightgreen")
ax.hist(np.random.normal(40, 12, 1000), bins=10, density=True, alpha=0.5, color="khaki")
ax.hist(np.random.normal(75, 5, 1000), bins=10, density=True, alpha=0.5, color="lightcoral")

# Add annotations
ax.annotate(
    annotation_texts[0],
    xy=(7, 0.20),
    xytext=(30, 0.25),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
    fontsize=12,
    ha="center"
)
ax.annotate(
    annotation_texts[1],
    xy=(40, 0.06),
    xytext=(75, 0.10),
    arrowprops=dict(facecolor="black", arrowstyle="<->"),
    fontsize=12,
    ha="center"
)

# Add text labels
ax.text(15, 0.18, "14 Years", fontsize=12, ha="center")
ax.text(40, 0.08, "49 Years", fontsize=12, ha="center")

# Set labels, title, and layout
ax.set_xlabel(xlabel, fontsize=14)
ax.set_ylabel(ylabel, fontsize=14)
ax.set_title(title, fontsize=16)
fig.suptitle(supertitle, fontsize=18, y=0.98)

# Set axis limits and ticks
ax.set_ylim(0.00, 0.30)
ax.set_yticks([0.00, 0.10, 0.20])

# Add legend
ax.legend(title=legendtitle, title_fontsize='13', fontsize='11', ncol=1, bbox_to_anchor=(1, 1))

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save the plot
plt.tight_layout()
plt.savefig("CB_102.pdf", bbox_inches="tight")
