

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data
years = [
    "2015", "2016", "2017", "2018", "2019", "2020", "2021", "2022"
]
team_a = [10, 12, 14, 16, 18, 20, 22, 24]
team_b = [8, 10, 12, 13, 15, 17, 19, 22]
team_c = [6, 8, 10, 12, 14, 16, 18, 20]
team_d = [4, 6, 8, 10, 12, 14, 16, 18]
growth = [0.08, 0.12, 0.15, 0.10, 0.15, 0.20, 0.18, 0.22]
labels = ["Team A", "Team B", "Team C", "Team D"]
xlabel = "Year"
ylabel1 = "Wins"
ylabel2 = "Growth %"
legend_title = "Football Teams"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(years))
color_team_a = "#7fc97f"
color_team_b = "#beaed4"
color_team_c = "#fdc086"
color_team_d = "#ffff99"
color_growth = "#386cb0"

ax1.bar(index, team_a, bar_width, label=labels[0], color=color_team_a)
ax1.bar(index + bar_width, team_b, bar_width, label=labels[1], color=color_team_b)
ax1.bar(index + 2 * bar_width, team_c, bar_width, label=labels[2], color=color_team_c)
ax1.bar(index + 3 * bar_width, team_d, bar_width, label=labels[3], color=color_team_d)

# Line plot
ax2 = ax1.twinx()
ax2.plot(
    years,
    growth,
    color=color_growth,
    marker="D",
    linestyle="--",
    linewidth=2,
    markersize=7,
)

# Annotate growth percentages
for i, gr in enumerate(growth):
    ax2.annotate(
        f"{gr*100:.0f}%",
        (index[i] + bar_width * 1.5, gr),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        color=color_growth,
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(years)

# Add legend
ax1.legend(loc="upper left", ncol=1, bbox_to_anchor=(1.05, 1), title=legend_title)
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# set ax2.yticklabels to be percentage
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the plot as a PDF file
plt.savefig("CB_103.pdf", bbox_inches="tight")

