
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for Air Quality Analysis
seasons = ["Winter", "Spring", "Summer", "Fall"]
city_A = [65, 55, 70, 60]
city_B = [60, 50, 68, 55]
city_C = [63, 52, 72, 58]
city_D = [62, 53, 71, 59]
annual_change = [-0.05, 0.02, 0.04, -0.03]

# Text labels
labels = ["City A", "City B", "City C", "City D"]
xlabel = "Season"
ylabel1 = "PM2.5 Levels (µg/m³)"
ylabel2 = "Annual Change (%)"
legend_title = "Cities"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(seasons))
ax1.bar(index, city_A, bar_width, label=labels[0], color="royalblue")
ax1.bar(index + bar_width, city_B, bar_width, label=labels[1], color="seagreen")
ax1.bar(index + 2 * bar_width, city_C, bar_width, label=labels[2], color="slateblue")
ax1.bar(index + 3 * bar_width, city_D, bar_width, label=labels[3], color="darkorange")

# Line plot for annual change
ax2 = ax1.twinx()
ax2.plot(
    seasons,
    annual_change,
    color="crimson",
    marker="s",
    linestyle="--",
    linewidth=2,
    markersize=6,
)

# Annotate annual change
for i, change in enumerate(annual_change):
    ax2.annotate(
        f"{change*100:.0f}%",
        (index[i] + bar_width * 1.5, change),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        color="crimson",
    )

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + bar_width * 1.5)
ax1.set_xticklabels(seasons)

# Add legend
ax1.legend(loc="upper left", ncol=2, bbox_to_anchor=(0.12, -0.1), title=legend_title)
ax1.grid(axis="y", linestyle="--", alpha=0.7)
ax1.set_axisbelow(True)

# set ax2.yticklabels to be percentage
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
# Save the plot as a PDF file
plt.savefig("CB_104.pdf", bbox_inches="tight")
