

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
from scipy.stats import gaussian_kde

# Generating sample data representing monthly rainfall for three cities
rainfall_city1 = np.random.normal(100, 20, 12)  # City A
rainfall_city2 = np.random.normal(80, 25, 12)   # City B
rainfall_city3 = np.random.normal(120, 30, 12)  # City C

# Creating KDE for each sample data set to estimate the density of data points
kde_city1 = gaussian_kde(rainfall_city1)
kde_city2 = gaussian_kde(rainfall_city2)
kde_city3 = gaussian_kde(rainfall_city3)

rainfall_range = np.linspace(30, 200, 50)  # Defining the range of rainfall for plotting
labels = ["City A (2021)", "City B (2021)", "City C (2021)"]
ax1_legend_title = "Cities"
ax1_xlabel = "Density"
ax2_ylabel = "Monthly Rainfall (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Setting up the figure and axes for a 1 x 2 layout
fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(10, 5))

# First subplot: Fill between plot along y-axis (KDE Plot)
ax1.fill_betweenx(rainfall_range, kde_city1(rainfall_range), color="#add8e6", alpha=0.4)
ax1.fill_betweenx(rainfall_range, kde_city2(rainfall_range), color="#f08080", alpha=0.5)
ax1.fill_betweenx(rainfall_range, kde_city3(rainfall_range), color="#dda0dd", alpha=0.3)
ax1.plot(kde_city1(rainfall_range), rainfall_range, label=labels[0], color="#0000ff", linestyle='--', linewidth=2)
ax1.plot(kde_city2(rainfall_range), rainfall_range, label=labels[1], color="#ff0000", linestyle='-.', linewidth=2)
ax1.plot(kde_city3(rainfall_range), rainfall_range, label=labels[2], color="#800080", linestyle='-', linewidth=2)
ax1.legend(title=ax1_legend_title, loc="upper right")
ax1.set_xlabel(ax1_xlabel)
ax1.set_yticks([])  # Hiding y-axis ticks for clarity

# Second subplot: Box plot for the same datasets along y-axis
box = ax2.boxplot(
    [rainfall_city1, rainfall_city2, rainfall_city3], vert=True, patch_artist=True, medianprops={"color": "black"}
)
colors = ["#add8e6", "#f08080", "#dda0dd"]  # Color matching with KDE plot
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_ylabel(ax2_ylabel)
ax2.set_xticks([])  # Hiding x-axis ticks for clarity
ax2.set_ylim(30, 200)  # Setting limits for y-axis to align with the KDE plot

# ===================
# Part 4: Saving Output
# ===================
# Displaying the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_113.pdf", bbox_inches="tight")
