
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Entertainment Sectors
entertainment_sectors = [
    "Movies",
    "TV Shows",
    "Music",
    "Video Games",
    "Live Concerts",
    "Streaming Services",
    "Amusement Parks",
    "Books",
    "Podcasts",
    "Virtual Reality",
]

# Budget allocation in 2013 (in million $)
budget_2013 = [80, 70, 50, 40, 60, 20, 30, 10, 5, 15]
# Budget allocation in 2022 (in million $)
budget_2022 = [100, 90, 80, 75, 85, 45, 50, 30, 25, 40]

x_label = "Budget Allocation (in million $)"
y_label = "Entertainment Sectors"
ax1_title = "Budget Allocation in 2013"
ax2_title = "Budget Allocation in 2022"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(12, 6), sharey=True)
colors = ["#6baed6", "#1c9099"]

# Plotting the bar graphs
for i, (budget, color) in enumerate(zip([budget_2013, budget_2022], colors)):
    axes[i].barh(entertainment_sectors, budget, color=color, edgecolor="gray")
    axes[i].set_xlabel(x_label)
    # Adding line graph on the same axes
    axes[i].plot(budget, entertainment_sectors, "o--", color="#d7301f", linewidth=1.5)

# Adding data labels
for ax, budget in zip(axes, [budget_2013, budget_2022]):
    for index, value in enumerate(budget):
        ax.text(value + 1, index, f" {value}", va="center")

# Set labels and titles
axes[0].set_title(ax1_title)
axes[1].set_title(ax2_title)
axes[0].set_ylabel(y_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.tight_layout()
plt.savefig("CB_116.pdf", bbox_inches="tight")
