
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Historical periods
historical_periods = [
    "Ancient Era",
    "Classical Antiquity",
    "Medieval Period",
    "Renaissance",
    "Early Modern Period",
    "Industrial Age",
    "20th Century",
    "Post-War Era",
    "Digital Age",
    "21st Century",
]

# Recognized historical sites in 2000
sites_2000 = [34, 47, 28, 19, 25, 38, 42, 51, 15, 7]
# Recognized historical sites in 2022
sites_2022 = [60, 95, 65, 40, 75, 90, 110, 150, 125, 80]

x_label = "Number of Recognized Sites"
y_label = "Historical Period"
ax1_title = "Recognized Historical Sites - 2000"
ax2_title = "Recognized Historical Sites - 2022"
plot_color_2000 = "lightblue"
plot_color_2022 = "lightcoral"
line_color = "#8a2be2"  # Purple
marker_shape = "s"  # Square markers

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with two subplots (1x2) and shared y-axis
fig, axes = plt.subplots(1, 2, figsize=(12, 6), sharey=True)

# Plotting the bar graphs
for i, (sites, color, ax_title) in enumerate(zip([sites_2000, sites_2022], [plot_color_2000, plot_color_2022], [ax1_title, ax2_title])):
    axes[i].barh(historical_periods, sites, color=color, edgecolor="gray")
    axes[i].set_xlabel(x_label)
    axes[i].set_title(ax_title)
    # Adding line graph on the same axes
    axes[i].plot(sites, historical_periods, marker_shape + "-", color=line_color, markerfacecolor="black")

# Adding data labels
for ax, sites in zip(axes, [sites_2000, sites_2022]):
    for index, value in enumerate(sites):
        ax.text(value + 1, index, f" {value}", va="center")

# Set y-axis label for the first subplot
axes[0].set_ylabel(y_label)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout to prevent clipping and overlap
plt.tight_layout()
plt.savefig("CB_117.pdf", bbox_inches="tight")
