
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(119)

# Sample technology data
months = ["January", "February", "March", "April"]
cpu_usage = [70, 65, 68, 72]  # CPU Usage in percentage
battery_life = [8, 7.5, 7.8, 8.2]  # Battery Life in hours
memory_usage = [60, 62, 59, 65]  # Memory Usage in percentage
network_speed = [50, 55, 52, 48]  # Network Speed in Mbps
performance_improvement = [0.05, 0.08, 0.06, 0.07]  # Improvement in performance scores

# Errors (e.g., standard deviation)
error_cpu = [2, 3, 2, 4]
error_battery = [0.2, 0.3, 0.2, 0.4]
error_memory = [3, 2, 3, 4]
error_network = [5, 6, 5, 7]
error_performance_improvement = [0.01, 0.015, 0.01, 0.02]
labels = ["CPU Usage", "Battery Life", "Memory Usage", "Network Speed"]
xlabel = "Month"
ylabel1 = "Performance Metrics"
ylabel2 = "Improvement %"
legend_title = "Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(10, 7))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(months))

# Colors
cpu_color = "#a6b1e1"
battery_color = "#f76c6c"
memory_color = "#ffcb77"
network_color = "#4ecdc4"
improvement_color = "#ff6b6b"

ax1.bar(
    index,
    cpu_usage,
    bar_width,
    label=labels[0],
    color=cpu_color,
    yerr=error_cpu,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + bar_width,
    battery_life,
    bar_width,
    label=labels[1],
    color=battery_color,
    yerr=error_battery,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 2 * bar_width,
    memory_usage,
    bar_width,
    label=labels[2],
    color=memory_color,
    yerr=error_memory,
    capsize=5,
    ecolor="gray",
)
ax1.bar(
    index + 3 * bar_width,
    network_speed,
    bar_width,
    label=labels[3],
    color=network_color,
    yerr=error_network,
    capsize=5,
    ecolor="gray",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    performance_improvement,
    yerr=error_performance_improvement,
    fmt="o-",
    color=improvement_color,
    label="Performance Improvement",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(months)

# Add legends
ax1.legend(loc="upper left", ncol=1, title=legend_title)
ax2.legend(loc="upper right", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 0.1)
ax2.set_yticks(np.linspace(0, 0.1, 5))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y", linestyle='--', alpha=0.7)
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_119.pdf", bbox_inches="tight")
