

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample political data: Poll percentages
quarters = ["Q1", "Q2", "Q3", "Q4"]
PartyA = [40, 42, 45, 47]
PartyB = [35, 36, 38, 40]
PartyC = [15, 16, 17, 19]
PartyD = [10, 12, 13, 14]
poll_improvement = [0.02, 0.01, 0.03, 0.02]

# Errors (e.g., margin of error)
errorA = [3, 2, 4, 3]
errorB = [2, 3, 3, 2]
errorC = [1, 2, 1, 2]
errorD = [2, 1, 3, 2]
error_poll_improvement = [0.01, 0.005, 0.015, 0.01]
labels = ["PartyA", "PartyB", "PartyC", "PartyD"]
xlabel = "Quarter"
ylabel1 = "Poll Percentage (%)"
ylabel2 = "Poll Improvement %"
legend_title = "Parties"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax1 = plt.subplots(figsize=(8, 6))

# Bar plot with error bars
bar_width = 0.2
index = np.arange(len(quarters))
ax1.bar(
    index,
    PartyA,
    bar_width,
    label=labels[0],
    color="forestgreen",
    yerr=errorA,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + bar_width,
    PartyB,
    bar_width,
    label=labels[1],
    color="skyblue",
    yerr=errorB,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + 2 * bar_width,
    PartyC,
    bar_width,
    label=labels[2],
    color="gold",
    yerr=errorC,
    capsize=5,
    ecolor="black",
)
ax1.bar(
    index + 3 * bar_width,
    PartyD,
    bar_width,
    label=labels[3],
    color="coral",
    yerr=errorD,
    capsize=5,
    ecolor="black",
)

# Line plot with error bars
ax2 = ax1.twinx()
ax2.errorbar(
    index + 1.5 * bar_width,
    poll_improvement,
    yerr=error_poll_improvement,
    fmt="s--",
    color="darkblue",
    label="Poll Improvement",
    linewidth=2,
    markersize=5,
    capsize=5,
)

# Set labels and title
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel1)
ax2.set_ylabel(ylabel2)

# Set x-axis tick labels
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(quarters)

# Add legends
ax1.legend(loc="lower center", ncol=4, bbox_to_anchor=(0.5, -0.25), title=legend_title)
ax2.legend(loc="upper left", ncol=1)

# Set ax2.yticklabels to be percentage
ax2.set_ylim(0, 0.05)
ax2.set_yticks(np.linspace(0, 0.05, 6))
ax2.set_yticklabels([f"{x*100:.0f}%" for x in ax2.get_yticks()])

# Grid and layout adjustment
ax1.grid(axis="y")
ax1.set_axisbelow(True)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_120.pdf", bbox_inches="tight")
