

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for monthly sales of two products
product_a_sales = np.random.normal(loc=100, scale=20, size=500)
product_b_sales = np.random.normal(loc=150, scale=30, size=500)

# Labels and Plot Types
ax1_label = "Product A"
ax2_label = "Product B"
ax1_text = "Mean Sales Product A"
ax2_text = "Mean Sales Product B"

# Axes Limits and Labels
xlabel_value = "Monthly Sales"
ylabel_value = "Density"
xticks_values = [50, 100, 150, 200, 250]
xlim_values = [30, 270]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 8))

# Plot histograms
ax.hist(product_a_sales, bins=15, density=True, alpha=0.7, color="#89CFF0", label=ax1_label)
ax.hist(product_b_sales, bins=15, density=True, alpha=0.7, color="#FF7F50", label=ax2_label)

# Plot normal distributions
xmin, xmax = ax.get_xlim()
x = np.linspace(xmin, xmax, 100)
p_a = norm.pdf(x, np.mean(product_a_sales), np.std(product_a_sales))
p_b = norm.pdf(x, np.mean(product_b_sales), np.std(product_b_sales))
ax.plot(x, p_a, color="#4682B4", linewidth=3)
ax.plot(x, p_b, color="#CD5C5C", linewidth=3)

# Add dashed lines at mean
ax.axvline(np.mean(product_a_sales), color="black", linestyle="dashed")
ax.axvline(np.mean(product_b_sales), color="black", linestyle="dashed")

# Add text labels for dashed lines
ax.text(np.mean(product_a_sales) + 1.5, ax.get_ylim()[1] - 0.01, ax1_text, ha="center", va="top", fontsize=18)
ax.text(np.mean(product_b_sales) + 1.5, ax.get_ylim()[1] - 0.005, ax2_text, ha="center", va="top", fontsize=18)

# Set labels and title
ax.set_xlabel(xlabel_value)
ax.set_ylabel(ylabel_value)
ax.set_xticks(xticks_values)
ax.set_xlim(xlim_values)

# Add legend
ax.legend()

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_33.pdf", bbox_inches="tight")

