
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Data for plotting
companies = [
    "Apple",
    "Microsoft",
    "Amazon",
    "Alphabet",
    "Facebook",
    "Tesla",
]
revenue = [274.52, 143.02, 386.06, 182.53, 86.00, 31.54]  # Billion USD
profit_margins = [21.24, 30.96, 5.52, 22.06, 32.02, 4.96]  # %
market_share = [50.0, 20.0, 40.0, 35.0, 25.0, 15.0]  # %
employee_growth = [7.0, 5.0, 11.0, 6.0, 9.0, 25.0]  # %

labels = ["Revenue (Billion USD)", "Profit Margins (%)", "Market Share (%)", "Employee Growth (%)"]
x_name = "Tech Companies"
bar_name = "Financial Metrics"
line_name = "Employee Growth (%)"
line_label = "Employee Growth"
title="Tech Companies Financial Metrics"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match the new domain's requirements
fig, ax1 = plt.subplots(figsize=(12, 6))

# Bar plot
bar_width = 0.2
index = np.arange(len(companies))
bar1 = ax1.bar(index, revenue, bar_width, label=labels[0], color="#3498db")
bar2 = ax1.bar(index + bar_width, profit_margins, bar_width, label=labels[1], color="#e74c3c")
bar3 = ax1.bar(index + 2 * bar_width, market_share, bar_width, label=labels[2], color="#2ecc71")

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(
    index + bar_width + bar_width / 2,
    employee_growth,
    label=line_label,
    color="#8e44ad",
    marker="s",
    markersize=10,
    linewidth=2,
    linestyle="--",
    markeredgewidth=2,
    markeredgecolor="white",
)

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=14, fontweight='bold')
ax1.set_ylabel(bar_name, fontsize=14, fontweight='bold')
ax1.set_xticks(index + bar_width + bar_width / 2)
ax1.set_xticklabels(companies, fontsize=12, rotation=45, ha='right')
ax1.legend(loc="upper left", fontsize=12)
ax2.legend(loc="upper right", fontsize=12)
ax2.set_ylabel(line_name, fontsize=14, fontweight='bold')

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

plt.title(title, fontsize=16, fontweight='bold')
plt.tight_layout()

# ===================
# Part 4: Saving Output
# ===================
# Save plot
plt.savefig("CB_40.pdf", bbox_inches="tight")

# Show plot
