

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data for plotting
crops = [
    "Wheat",
    "Corn",
    "Rice",
    "Soybean",
    "Barley",
    "Peanut",
]
water_usage = [0.25, 0.3, 0.4, 0.35, 0.2, 0.15]
co2_emissions = [0.1, 0.2, 0.15, 0.25, 0.3, 0.2]
pesticide_usage = [0.3, 0.35, 0.25, 0.4, 0.3, 0.25]
maintenance_cost = [0.2, 0.3, 0.25, 0.4, 0.35, 0.3]
yield_effectiveness = [75, 85, 95, 80, 70, 90]
labels = ["Water Usage", "CO2 Emissions", "Pesticide Usage", "Maintenance Cost"]
x_name = "Crop Types"
bar_name = "Normalized Factors (lower is better)"
line_name = "Yield Effectiveness (%)"
line_label = "Yield Effectiveness"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image's dimensions
fig, ax1 = plt.subplots(figsize=(10, 5))

# Bar plot
bar_width = 0.2
index = np.arange(len(crops))
bar1 = ax1.bar(index, water_usage, bar_width, label=labels[0], color="#76c7c0")
bar2 = ax1.bar(
    index + bar_width,
    co2_emissions,
    bar_width,
    label=labels[1],
    color="#ffcc5c",
)
bar3 = ax1.bar(
    index + 2 * bar_width, pesticide_usage, bar_width, label=labels[2], color="#6b5b95"
)
bar4 = ax1.bar(
    index + 3 * bar_width,
    maintenance_cost,
    bar_width,
    label=labels[3],
    color="#d64161",
)

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(
    index + bar_width + bar_width / 2,
    yield_effectiveness,
    label=line_label,
    color="black",
    marker="D",
    markersize=10,
    linewidth=2,
    linestyle='--',
    markeredgecolor="white",
)

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=12)
ax1.set_ylabel(bar_name, fontsize=12)
ax1.set_xticks(index + bar_width + bar_width / 2)
ax1.set_xticklabels(crops, fontsize=12)
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")
ax2.set_ylabel(line_name, fontsize=12)

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_41.pdf", bbox_inches="tight")
