

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(1)

# Data for plotting
courses = ["Course A", "Course B", "Course C", "Course D", "Course E", "Course F"]
study_hours = [2.5, 3.0, 4.0, 3.5, 3.0, 2.8]
homework_completion_rate = [88, 92, 85, 91, 89, 87]
class_participation = [75, 80, 70, 85, 78, 76]
project_scores = [82, 79, 88, 86, 84, 81]
overall_grades = [78, 82, 80, 85, 83, 79]

# Labels and Titles
labels = ["Study Hours (hrs)", "Homework Completion Rate (%)", "Class Participation Rate (%)", "Group Project Scores"]
x_name = "Courses"
bar_name = "Performance Metrics"
line_name = "Overall Grades (%)"
line_label = "Overall Grade"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image's dimensions
fig, ax1 = plt.subplots(figsize=(12, 6))

# Colors for the bars
color_study_hours = "#4b8bbe"
color_homework_completion = "#f4a582"
color_class_participation = "#92c5de"
color_project_scores = "#d6604d"
color_overall_grades = "#2166ac"

# Bar plot
bar_width = 0.2
index = np.arange(len(courses))
bar1 = ax1.bar(index, study_hours, bar_width, label=labels[0], color=color_study_hours)
bar2 = ax1.bar(index + bar_width, homework_completion_rate, bar_width, label=labels[1], color=color_homework_completion)
bar3 = ax1.bar(index + 2 * bar_width, class_participation, bar_width, label=labels[2], color=color_class_participation)
bar4 = ax1.bar(index + 3 * bar_width, project_scores, bar_width, label=labels[3], color=color_project_scores)

# Line plot
ax2 = ax1.twinx()
line = ax2.plot(index + 1.5 * bar_width, overall_grades, label=line_label, color=color_overall_grades, marker="X", markersize=14, linewidth=2, markeredgecolor="white")

# Labels, title and legend
ax1.set_xlabel(x_name, fontsize=12)
ax1.set_ylabel(bar_name, fontsize=12)
ax1.set_xticks(index + 1.5 * bar_width)
ax1.set_xticklabels(courses, fontsize=12)
ax1.legend(loc="upper left", fontsize=9)
ax2.legend(loc="upper right", fontsize=9)
ax2.set_ylabel(line_name, fontsize=12)

ax1.tick_params(axis="y", labelsize=12)
ax2.tick_params(axis="y", labelsize=12)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_42.pdf", bbox_inches="tight")

