

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
months = np.arange(1, 13)
before_campaign = [400, 390, 395, 405, 410, 420, 415, 425, 430, 440, 435, 445]
after_campaign = [390, 380, 370, 360, 355, 350, 345, 340, 335, 330, 320, 310]
percentages = [
    "2.5%", "2.6%", "6.3%", "11.1%", "13.4%", "16.7%", "16.9%", "20%", "22.1%", "25%", "26.4%", "30.3%"
]

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Electricity Consumption (in kWh)"
xticklabels = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"]
title='Monthly Electricity Consumption Before and After Efficiency Campaign'
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 6))

# Plot data with different marker style
ax.plot(months, before_campaign, color="#ffa500", linestyle="--", linewidth=2, label='Before Campaign')
ax.plot(months, after_campaign, color="#1f77b4", linestyle="--", linewidth=2, label='After Campaign')
ax.scatter(months, before_campaign, marker="o", color="#ffa500", s=100)
ax.scatter(months, after_campaign, marker="^", color="#1f77b4", s=100)

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (months[i], after_campaign[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
        color='black'
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)

# Set ticks
ax.set_xticks(months)
ax.set_yticks(range(300, 460, 20))

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=9)
ax.set_yticklabels(range(300, 460, 20), fontsize=9)

# Set grid with lighter lines
ax.grid(True, linestyle="--", linewidth=0.5, color="gray")

# Add title and legend
ax.set_title(title, fontsize=14)
ax.legend(loc='upper left', fontsize=10)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_49.pdf", bbox_inches="tight")

