
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Data
months = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12]
advertising_budget = [20, 40, 60, 80, 100, 120, 140, 160, 180, 200, 220, 240]  # Advertising Budget in $1000s
revenue = [25, 28, 35, 40, 55, 65, 72, 85, 95, 110, 125, 140]  # Revenue in $1000s

percentages = [
    "$25K",
    "$28K",
    "$35K",
    "$40K",
    "$55K",
    "$65K",
    "$72K",
    "$85K",
    "$95K",
    "$110K",
    "$125K",
    "$140K",
]

# Axes Limits and Labels
xlabel_value = "Months"
ylabel_value = "Revenue ($1000s)"
xticklabels = [f"Month {num}" for num in months]
yticklabels = [f"${num}K" for num in revenue]
title="Correlation Between Advertising Budget and Revenue"
suptitle="Economic Data Analysis"
# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axis
fig, ax = plt.subplots(figsize=(10, 7))

# Plot data with different marker style
ax.plot(months, revenue, color="#2ca02c", linestyle="--", linewidth=2)  # Green dashed line
ax.scatter(months, revenue, marker="D", color="#ff7f0e", s=100)  # Orange diamond marker

# Annotate percentages with different font style
for i, txt in enumerate(percentages):
    ax.annotate(
        txt,
        (months[i], revenue[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=10,
        fontweight='bold'
    )

# Set labels with different font style
ax.set_xlabel(xlabel_value, fontsize=14)
ax.set_ylabel(ylabel_value, fontsize=14)

# Set ticks
ax.set_xticks(months)
ax.set_yticks(revenue)

# Set tick labels with different font style
ax.set_xticklabels(xticklabels, fontsize=10)
ax.set_yticklabels(yticklabels, fontsize=10)

# Set grid with lighter lines
ax.grid(True, linestyle="-.", linewidth=0.7, color="gray")

# Set title
ax.set_title(title, fontsize=16, fontweight='bold')
fig.suptitle(suptitle, fontsize=18, fontweight='bold')

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_50.pdf", bbox_inches="tight")

