
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample data for sports domain (basketball players)
heights = np.random.normal(loc=6.5, scale=0.2, size=1000)  # Normally distributed heights in feet
weights = np.random.normal(loc=210, scale=25, size=1000)   # Normally distributed weights in pounds
xlabel = "Height (ft)"
ylabel = "Weight (lbs)"
title = "Height vs Weight Distribution of Basketball Players"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and gridspec
fig = plt.figure(figsize=(8, 8))
gs = gridspec.GridSpec(2, 2, width_ratios=[5, 1], height_ratios=[1, 5])

# Main hexbin plot
ax = plt.subplot(gs[1, 0])
hb = ax.hexbin(heights, weights, gridsize=30, cmap="YlGnBu", mincnt=1, edgecolors='grey')
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(5.8, 7.2)
ax.set_ylim(140, 280)
ax.axhline(210, color="gray", linestyle="--", linewidth=1)
ax.axvline(6.5, color="gray", linestyle="--", linewidth=1)

# Color bar
cb = fig.colorbar(hb, ax=ax)
cb.set_label('Counts')

# Histogram on the top
ax_histx = plt.subplot(gs[0, 0], sharex=ax)
ax_histx.hist(heights, bins=30, color="lightblue", edgecolor="darkblue", linewidth=1.2)
ax_histx.axis("off")  # Hide axis

# Histogram on the right
ax_histy = plt.subplot(gs[1, 1], sharey=ax)
ax_histy.hist(
    weights,
    bins=25,
    orientation="horizontal",
    color="lightgreen",
    edgecolor="darkgreen",
    linewidth=1.2,
)
ax_histy.axis("off")  # Hide axis

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the figure
plt.tight_layout()
plt.savefig("CB_54.pdf", bbox_inches="tight")
