

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
np.random.seed(0)

# Data
modes = ["Car", "Bus", "Train", "Bicycle"]
comfort_values = [0.75, 0.60, 0.85, 0.90]
reliability_values = [0.80, 0.70, 0.90, 0.85]
overall_values = [1.55, 1.30, 1.75, 1.75]
labels = ["Comfort", "Reliability", "Overall Score"]
xlabel = "Transportation Modes"
ylabel = "Values"
title = "Performance Metrics for Transportation Modes"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Bar plot
fig, ax1 = plt.subplots(
    figsize=(10, 6)
)

bar_width = 0.35
index = np.arange(len(modes))
color1 = "#4C72B0"
color2 = "#55A868"
color3 = "#DD8452"

bar1 = ax1.bar(index, comfort_values, bar_width, label=labels[0], color=color1)
bar2 = ax1.bar(
    index + bar_width, reliability_values, bar_width, label=labels[1], color=color2
)

# Line plot
ax2 = ax1.twinx()
(line,) = ax2.plot(index + bar_width / 2, overall_values, color=color3, marker="s", linestyle='--', linewidth=2, label=labels[2])

# Annotate bars with values
for rect, value in zip(bar1, comfort_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.02,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

for rect, value in zip(bar2, reliability_values):
    height = rect.get_height()
    ax1.text(
        rect.get_x() + rect.get_width() / 2,
        height + 0.02,
        f"{value:.2f}",
        ha="center",
        va="bottom",
    )

# Labels, title and legend
ax1.set_xlabel(xlabel)
ax1.set_ylabel(ylabel)
ax1.set_title(title)
ax1.set_xticks(index + bar_width / 2)
ax1.set_xticklabels(modes)
ax1.set_ylim(0.55, 1.0)
ax1.set_yticks([0.55, 0.65, 0.75, 0.85, 0.95])
ax2.set_ylim(1.25, 1.80)
ax2.set_yticks([1.25, 1.40, 1.55, 1.70])
ax1.legend(loc="upper left")
ax2.legend(loc="upper right")

ax1.yaxis.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Adjust figure size to match original image's dimensions
fig.set_size_inches(10, 6)

# Show plot
plt.tight_layout()
plt.savefig("CB_56.pdf", bbox_inches="tight")

