
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample (x,y) data for scatter plot
data = {
    "Parks": [[np.random.randint(50, 300), np.random.uniform(200, 400)] for _ in range(10)],
    "Museums": [[np.random.randint(150, 400), np.random.uniform(300, 500)] for _ in range(10)],
    "Beaches": [[np.random.randint(100, 350), np.random.uniform(100, 300)] for _ in range(10)],
}

# Regression line data
line_x = np.array([50, 100, 150, 200, 250, 300, 350, 400])
line_y = np.array([200, 250, 300, 350, 400, 450, 500, 550])

# Text and labels
labels = ["Parks", "Museums", "Beaches"]
correlation = 0.88
xlabel = "Number of Visitors (in thousands)"
ylabel = "Satisfaction Score"
legend_title = "Attraction Type"
correlation_text = f"Correlation: {correlation:.2f}"
title="Visitor Satisfaction Across Different Tourist Attractions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#1f77b4", "#2ca02c", "#9467bd"]  # Custom color scheme

plt.figure(figsize=(8, 6))  # Adjust figure size

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key)

# Add regression line
plt.plot(line_x, line_y, color="#ff7f0e", linestyle='--', linewidth=2)

# Add shaded area for standard deviation
std_dev = 25
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="#ff7f0e", alpha=0.2)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="upper left")

# Add correlation text inside the plot area
plt.text(line_x[-2], line_y[-2] - 30, correlation_text, fontsize=10, bbox=dict(facecolor='white', alpha=0.5))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

plt.grid(True)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_58.pdf", bbox_inches="tight")
