
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample (x, y) for the scatter plot representing number of soldiers (x) and battle duration (y)
data = {
    "Small": [[np.random.randint(500, 2000), np.random.rand() * 1 + 1] for _ in range(10)],
    "Medium": [[np.random.randint(2000, 5000), np.random.rand() * 2 + 2] for _ in range(10)],
    "Large": [[np.random.randint(5000, 10000), np.random.rand() * 3 + 3] for _ in range(10)],
}

line_x = np.array([500, 2000, 3500, 5000, 7500, 10000])
line_y = np.array([1, 2, 3, 4, 5, 6])

labels = ["Small", "Medium", "Large"]
correlation = 0.65
xlabel = "Number of Soldiers"
ylabel = "Duration of Battle (hours)"
legend_title = "Battle Size Categories"
correlation = f"Correlation: {correlation:.2f}"
title="Relationship between Number of Soldiers and Battle Duration"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================

colors = ["#2ca02c", "#ff7f0e", "#d62728"]  # Use HEX color codes for domain-specific colors
# Create scatter plot
plt.figure(figsize=(10, 6))  # Adjust figure size to match original image dimensions

for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, s=80, edgecolors='w', linewidths=0.5)

# Add regression line
plt.plot(line_x, line_y, color="gray", linestyle="--", linewidth=2)

# Add shaded area for standard deviation
std_dev = 1
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="gray", alpha=0.2)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="upper left")

# Add correlation text with a box inside the plot area
plt.text(line_x[-2], line_y[-2] + 0.3, correlation, fontsize=10, bbox=dict(facecolor='white', alpha=0.6))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

plt.yticks(np.arange(line_y.min(), line_y.max() + 1, 1))

# Set grid
plt.grid(True, linestyle='--', alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_59.pdf", bbox_inches="tight")
