

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Sample (x,y) for the scatter plot
data = {
    "Low Sales": [[np.random.randint(2000, 5000), np.random.rand() * 20 + 50] for _ in range(10)],
    "Moderate Sales": [[np.random.randint(5000, 8000), np.random.rand() * 20 + 60] for _ in range(2)],
    "High Sales": [[np.random.randint(8000, 12000), np.random.rand() * 20 + 70] for _ in range(10)],
}

line_x = np.array([2000, 4000, 6000, 8000, 10000, 12000])
line_y = np.array([50, 60, 70, 80, 90, 100])

labels = ["Low Sales", "Moderate Sales", "High Sales"]
correlation = 0.75
xlabel = "Monthly Sales (USD)"
ylabel = "Customer Satisfaction Score"
legend_title = "Sales Performance"
correlation = f"Correlation: {correlation:.2f}"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
colors = ["#8BC34A", "#FFC107", "#FF5722"]  # Greens and warm colors

plt.figure(figsize=(9, 6))  # Adjust figure size

# Add scatter plot points
for key in data:
    x = [item[0] for item in data[key]]
    y = [item[1] for item in data[key]]
    plt.scatter(x, y, color=colors[labels.index(key)], label=key, edgecolor='k', s=100, alpha=0.7)

# Add regression line
plt.plot(line_x, line_y, color="black", linestyle='--', linewidth=2)

# Add shaded area for standard deviation
std_dev = 5
plt.fill_between(line_x, line_y - std_dev, line_y + std_dev, color="gray", alpha=0.2)

# Add legend inside the plot area
plt.legend(title=legend_title, loc="upper right")

# Add correlation text with a box inside the plot area
plt.text(line_x[-2], line_y[-2], correlation, fontsize=12, bbox=dict(facecolor='white', alpha=0.5, edgecolor='none'))

# Set labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)

plt.yticks(np.arange(line_y.min(), line_y.max() + 10, 10))

# Set grid
plt.grid(True, linestyle='--', linewidth=0.5, alpha=0.7)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_60.pdf", bbox_inches="tight")

