
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Sample data for demonstration purposes
region_a_rainfall = np.random.normal(loc=800, scale=100, size=1000)  # rainfall in mm/year
region_b_rainfall = np.random.normal(loc=1200, scale=150, size=1000)  # rainfall in mm/year

# Compute KDE for both datasets
kde_region_a = gaussian_kde(region_a_rainfall)
kde_region_b = gaussian_kde(region_b_rainfall)

# Create an array of values for plotting KDE
x_eval = np.linspace(
    min(np.concatenate([region_a_rainfall, region_b_rainfall])),
    max(np.concatenate([region_a_rainfall, region_b_rainfall])),
    1000,
)
labels = ["Region A rainfall", "Region B rainfall", "Region A KDE", "Region B KDE"]
p_text = "T-test p-value = 0.0000"
x_label = "Rainfall (mm/year)"
y_label = "Density"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Plot histograms
region_a_color = "#ffeb3b"
region_b_color = "#4caf50"
region_a_kde_color = "#f57f17"
region_b_kde_color = "#1b5e20"

plt.hist(
    region_b_rainfall, density=True, bins=30, color=region_b_color, alpha=0.8, label=labels[0]
)
plt.hist(
    region_a_rainfall, density=True, bins=30, color=region_a_color, alpha=0.8, label=labels[1]
)

# Plot KDEs
plt.plot(
    x_eval,
    kde_region_b(x_eval),
    linestyle="-",
    color=region_b_kde_color,
    label=labels[2],
)
plt.plot(
    x_eval,
    kde_region_a(x_eval),
    linestyle="-",
    color=region_a_kde_color,
    label=labels[3],
)

# Add legend
plt.legend()

# Add T-test p-value text
plt.text(1000, 0.002, p_text, fontsize=10)

# Set labels and title
plt.xlabel(x_label)
plt.ylabel(y_label)

# Add grid for better readability
plt.grid(True, linestyle='--', alpha=0.6)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_64.pdf", bbox_inches="tight")
