

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate new data for media domain
streaming_service1 = np.random.gamma(shape=2, scale=30, size=1000)  # viewing times in minutes
streaming_service2 = np.random.gamma(shape=5, scale=20, size=1000)  # viewing times in minutes

# Compute KDE for both datasets
kde_service1 = gaussian_kde(streaming_service1)
kde_service2 = gaussian_kde(streaming_service2)

# Create an array of values for plotting KDE
x_eval = np.linspace(
    min(np.concatenate([streaming_service1, streaming_service2])),
    max(np.concatenate([streaming_service1, streaming_service2])),
    1000,
)

# Text labels and annotation details
labels = ["Streaming Service 1", "Streaming Service 2", "Service 1 KDE", "Service 2 KDE"]
p_text = "Mann-Whitney U test p-value = 0.0000"
x_label = "Viewing Time (minutes)"
y_label = "Density"
title = "Viewing Time Distribution for Different Streaming Services"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to a comfortable readable size
plt.figure(figsize=(10, 6))

# Plot histograms with custom colors and transparency
plt.hist(
    streaming_service1, density=True, bins=30, color="#4db8ff", alpha=0.7, label=labels[0]
)
plt.hist(
    streaming_service2, density=True, bins=30, color="#ffa64d", alpha=0.7, label=labels[1]
)

# Plot KDEs with different line styles and widths
plt.plot(
    x_eval,
    kde_service1(x_eval),
    linestyle="dashed",
    color="blue",
    linewidth=2,
    label=labels[2],
)
plt.plot(
    x_eval,
    kde_service2(x_eval),
    linestyle="dashed",
    color="red",
    linewidth=2,
    label=labels[3],
)

# Add legend
plt.legend()

# Add text annotation for statistical test result
plt.text(120, 0.006, p_text, fontsize=10)

# Set labels, title and other plot details
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.title(title)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_65.pdf", bbox_inches="tight")

