

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Data
activities = ["Prayer", "Meditation", "Community Service", "Study Groups"]
scores_teenagers = [0.40, 0.30, 0.20, 0.25]
scores_young_adults = [0.50, 0.45, 0.35, 0.40]
scores_adults = [0.60, 0.50, 0.40, 0.55]
scores_seniors = [0.70, 0.65, 0.55, 0.60]
trend = [0.55, 0.48, 0.37, 0.45]
title = "Religious Activity Participation Across Age Groups"
labels = [
    "Teenagers",
    "Young Adults",
    "Adults",
    "Seniors",
    "Trend",
]
x_label = "Religious Activities"
y_label = "Participation Scores"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 5))

# Bar width
barWidth = 0.2

# Set position of bar on X axis
r1 = np.arange(len(scores_teenagers))
r2 = [x + barWidth for x in r1]
r3 = [x + barWidth for x in r2]
r4 = [x + barWidth for x in r3]

# Make the plot
plt.bar(
    r1,
    scores_teenagers,
    color="#4daf4a",
    width=barWidth,
    edgecolor="white",
    label=labels[0],
)
plt.bar(
    r2,
    scores_young_adults,
    color="#377eb8",
    width=barWidth,
    edgecolor="white",
    label=labels[1],
)
plt.bar(
    r3,
    scores_adults,
    color="#ff7f00",
    width=barWidth,
    edgecolor="white",
    label=labels[2],
)
plt.bar(
    r4,
    scores_seniors,
    color="#e41a1c",
    width=barWidth,
    edgecolor="white",
    label=labels[3],
)

# Add trend line
plt.plot(
    [r + barWidth * 1.5 for r in r1],
    trend,
    color="black",
    marker="x",
    linestyle="--",
    linewidth=2,
    markersize=6,
    label=labels[4],
)

# Add xticks on the middle of the group bars
plt.xlabel(x_label)
plt.ylabel(y_label)
plt.xticks([r + barWidth * 1.5 for r in range(len(scores_teenagers))], activities)
plt.ylim(0, 1)
plt.yticks(np.arange(0, 1.1, 0.1))

# Create legend & Show graphic
plt.title(title)
plt.legend(loc="upper right", ncol=1)

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("CB_67.pdf", bbox_inches="tight")

