

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt


# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)

# Generate new data for the economics domain (e.g., household income levels)
income_levels_urban = np.random.normal(55000, 15000, 1000)  # Urban population income levels
income_levels_rural = np.random.normal(35000, 10000, 1000)  # Rural population income levels

min_bin = min(min(income_levels_urban), min(income_levels_rural))
max_bin = max(max(income_levels_urban), max(income_levels_rural))

bins = np.linspace(min_bin, max_bin, 30)
bin_width = bins[1] - bins[0]
labels = ["Urban Population", "Rural Population"]
legend_title = "Population Group"
title = "Distribution of Household Income Levels"
xlabel = "Household Income ($)"
ylabel = "Frequency"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
figure = plt.figure(figsize=(10, 6))

# Create histogram
count_urban, bins_urban, _ = plt.hist(
    income_levels_urban,
    bins=bins,
    color="#8ecae6",
    alpha=0.7,
    label=labels[0],
    edgecolor="black",
    linewidth=1.25,
)
count_rural, bins_rural, _ = plt.hist(
    income_levels_rural,
    bins=bins,
    alpha=0.7,
    color="#219ebc",
    label=labels[1],
    edgecolor="black",
    linewidth=1.25,
)

# Create line plot on top of the histogram and set edge color
plt.plot(bins_urban[:-1] + bin_width * 0.5, count_urban, color="#006d77", linestyle='--', linewidth=1.5)
plt.plot(bins_rural[:-1] + bin_width * 0.5, count_rural, color="#023047", linestyle=':', linewidth=1.5)

# Add legend, title, and labels
plt.legend(loc="upper left", title=legend_title)
plt.title(title)
plt.xlabel(xlabel)
plt.ylabel(ylabel)

# ===================
# Part 4: Saving Output
# ===================
# Show plot with tight layout
plt.tight_layout()
plt.savefig("CB_71.pdf", bbox_inches="tight")
