

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Generate random data to simulate the plot
data_mindfulness = np.random.normal(60, 10, 50)
data_cbt = np.random.normal(55, 12, 50)

# Combine data into a list
data = [data_mindfulness, data_cbt]

# Create positions for each box plot
positions = [0, 1]
xticks = ["Mindfulness-Based Therapy", "Cognitive Behavioral Therapy"]
xlabel = "Psychological Intervention Techniques"
ylabel = "Assessment Scores"

# Additional text labels
title = "Effectiveness of Psychological Interventions"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to match the original image's dimensions
plt.figure(figsize=(8, 6))

# Calculate the kernel density estimate and plot the density plot for each dataset
colors = ["#56B4E9", "#009E73"]
for i, d in enumerate(data):
    # Calculate KDE
    kde = gaussian_kde(d)
    # Create an array of values covering the entire range of data for KDE
    kde_x = np.linspace(min(d), max(d), 300)
    kde_y = kde(kde_x)
    # Scale KDE values to match the position of the boxplot
    kde_y_scaled = kde_y / kde_y.max() * 0.1  # Scale factor can be adjusted
    # Plot filled density plot to the left of the boxplot
    offset = 0.2
    plt.fill_betweenx(
        kde_x,
        positions[i] - kde_y_scaled - offset,
        positions[i] - offset,
        color=colors[i],
        edgecolor="black",
        linestyle="--"
    )

# Create box plots inside the violin plots
for i, d in enumerate(data):
    plt.boxplot(
        d,
        positions=[positions[i]],
        widths=0.15,
        patch_artist=True,
        medianprops=dict(color="black"),
        boxprops=dict(facecolor="none", color="black"),
    )

# Add scatter plot for individual data points with different markers
markers = ['o', 'X']
for i, d in enumerate(data):
    x = np.random.normal(positions[i], 0.04, size=len(d))
    plt.scatter(x, d, color=colors[i], s=40, marker=markers[i])

# Set the x-axis labels and add title
plt.xticks([0, 1], xticks)
plt.xlabel(xlabel)
plt.title(title)

# Set the y-axis label
plt.ylabel(ylabel)

# Adjust the y-axis limits
plt.ylim(20, 90)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_77.pdf", bbox_inches="tight")

