
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
methods = ["Bus", "Train", "Bicycle", "Car"]
efficiency_scores = [0.60, 0.75, 0.95, 0.70]
satisfaction_scores = [0.65, 0.78, 0.90, 0.82]

# Axes Limits and Labels
ax1_title = "Efficiency Scores by Transportation Mode"
ax1_ylim = [0.55, 1.00]
ax1_ylabel = "Efficiency"

ax2_title = "User Satisfaction Scores by Transportation Mode"
ax2_ylim = [0.55, 1.00]
ax2_ylabel = "Satisfaction"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create figure and axes

new_colors = ["#76C7C0", "#4F9DA6", "#77B5A7", "#5A9E9D"]

fig, (ax1, ax2) = plt.subplots(1, 2, figsize=(12, 6))

# Bar chart for Efficiency Scores
ax1.bar(methods, efficiency_scores, color=new_colors)
ax1.plot(methods, efficiency_scores, marker="D", linestyle="--", color="#3B8686")
for i, score in enumerate(efficiency_scores):
    ax1.text(i, score, f"{score*100:.2f}%", ha="center", va="bottom", fontsize=10)
ax1.set_title(ax1_title, fontsize=14)
ax1.set_ylim(ax1_ylim)
ax1.set_ylabel(ax1_ylabel, fontsize=12)
# Set ax1 background color and grid
ax1.set_facecolor("#E3F2FD")
ax1.grid(True, which='both', linestyle='--', linewidth=0.5)

# Bar chart for Satisfaction Scores
ax2.bar(methods, satisfaction_scores, color=new_colors)
ax2.plot(methods, satisfaction_scores, marker="o", linestyle="-.", color="#FF6F61")
for i, score in enumerate(satisfaction_scores):
    ax2.text(i, score, f"{score*100:.2f}%", ha="center", va="bottom", fontsize=10)
ax2.set_title(ax2_title, fontsize=14)
ax2.set_ylim(ax2_ylim)
ax2.set_ylabel(ax2_ylabel, fontsize=12)
# Set ax2 background color and grid
ax2.set_facecolor("#E8F5E9")
ax2.grid(True, which='both', linestyle='--', linewidth=0.5)

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and save plot
plt.tight_layout()
plt.savefig("CB_81.pdf", bbox_inches="tight")
