

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(0)

# Data: Approval Ratings Over a Political Term
term_years = np.array([1, 2, 3, 4, 5, 6, 7, 8])
approval_ratings = np.array([55, 58, 60, 57, 59, 62, 64, 61])
initial_approval = np.array([55])
polling_error = np.array([2])

# Labels and Titles
xlabel = "Years in Office"
ylabel = "Approval Rating (%)"
title = "Public Approval Ratings Over a Political Term"
errorbar_label = "Initial Approval"
line_label = "Approval Ratings"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(figsize=(6, 4))  # Adjusting figure size to 432x288 pixels

# Approval Ratings
ax.plot(
    term_years,
    approval_ratings,
    marker="s",
    color="green",
    linestyle="--",
    linewidth=2,
    label=line_label,
)
ax.fill_between(
    term_years, approval_ratings - 2, approval_ratings + 2, color="#b3ffb3", alpha=0.4
)

# Initial Approval
ax.errorbar(
    term_years[0],
    initial_approval,
    yerr=polling_error,
    fmt="o",
    color="brown",
    label=errorbar_label,
    capsize=5,
)

# Customizing the plot
ax.set_xlabel(xlabel)
ax.set_ylabel(ylabel)
ax.set_title(title)
ax.set_xlim(0, 9)
ax.set_ylim(50, 70)
ax.legend(loc="upper left")
ax.grid(True)
ax.set_xticks(term_years)

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_84.pdf", bbox_inches="tight")

