
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new data
content_formats = ["Math", "Science", "History", "Arts", "Technology"]
content_sizes = [30, 40, 50, 60, 70]
engagement_2021 = [70, 55, 65, 60, 75]
engagement_2022 = [75, 60, 70, 65, 80]
labels = ["2021", "2022"]
ylabel = "Popularity Score"
xlabel = "Topic Size (arbitrary units)"
title = "Popularity of Education Topics Over Years"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Plotting
fig, ax = plt.subplots(
    figsize=(10, 7)
)  # Adjusting figure size to match new dimensions
ax.plot(
    content_sizes,
    engagement_2021,
    "--o",
    label=labels[0],
    color="#FF5733",
    markersize=8,
)
ax.plot(
    content_sizes,
    engagement_2022,
    "-.s",
    label=labels[1],
    color="#33FFCE",
    markersize=8,
)

# Annotating data points
for i, txt in enumerate(content_formats):
    ax.annotate(
        f"{engagement_2021[i]}%\n{txt}",
        (content_sizes[i], engagement_2021[i]),
        textcoords="offset points",
        xytext=(0, 10),
        ha="center",
        fontsize=9,
        color="black",
    )
    ax.annotate(
        f"{engagement_2022[i]}%\n{txt}",
        (content_sizes[i], engagement_2022[i]),
        textcoords="offset points",
        xytext=(0, -15),
        ha="center",
        fontsize=9,
        color="black",
    )

# Legend
ax.legend(loc="lower right")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title(title)
ax.set_yticks(np.arange(50, 85, 5))
ax.set_ylim([50, 85])
ax.set_xlim([20, 80])

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_85.pdf", bbox_inches="tight")
