

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data
years = [2000, 2005, 2010, 2015, 2020]
rainfall_country_A = [120.5, 130.2, 125.7, 140.9, 150.2]
rainfall_country_B = [110.0, 115.2, 118.5, 121.8, 125.0]
models_country_A = ["2000 A", "2005 A", "2010 A", "2015 A", "2020 A"]
models_country_B = ["2000 B", "2005 B", "2010 B", "2015 B", "2020 B"]
labels = ["Country A", "Country B"]
ylabel = "Average Monthly Rainfall (mm)"
xlabel = "Year"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Color Scheme (Retained)
color_A = "#FA8072"
color_B = "#FF6347"

# Plotting
fig, ax = plt.subplots(figsize=(8, 6))  # Adjusting figure size to match new dimensions
ax.plot(years, rainfall_country_A, "--o", label=labels[0], color=color_A, markersize=8, linewidth=2)
ax.plot(years, rainfall_country_B, "-.*", label=labels[1], color=color_B, markersize=10, linewidth=2)

# Annotating data points
for i, txt in enumerate(models_country_A):
    ax.annotate(f"{rainfall_country_A[i]} mm\n{txt}", (years[i], rainfall_country_A[i]), textcoords="offset points", xytext=(0, 10), ha="center")

for i, txt in enumerate(models_country_B):
    ax.annotate(f"{rainfall_country_B[i]} mm\n{txt}", (years[i], rainfall_country_B[i]), textcoords="offset points", xytext=(0, 10), ha="center")

# Legend
ax.legend(loc="upper left")

# Labels and Title
ax.set_ylabel(ylabel)
ax.set_xlabel(xlabel)
ax.set_title('Average Monthly Rainfall Trends')
ax.set_yticks(np.arange(100, 160, 10))
ax.set_ylim([100, 160])
ax.set_xlim([1995, 2025])

# ===================
# Part 4: Saving Output
# ===================
# Show plot
plt.tight_layout()
plt.savefig("CB_86.pdf", bbox_inches="tight")

