

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import gaussian_kde

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for the line plot - monthly rainfall in mm
city_A = np.random.normal(80, 20, 100)
city_B = np.random.normal(100, 25, 100)
city_C = np.random.normal(60, 15, 100)

kde_city_A = gaussian_kde(city_A)
kde_city_B = gaussian_kde(city_B)
kde_city_C = gaussian_kde(city_C)

x_range = np.linspace(0, 200, 100)  # plausible range for monthly rainfall (mm)
labels = ["City A", "City B", "City C"]
title = "City"
xlabel = "Monthly Rainfall (mm)"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create a figure with specific size to match the original image's dimensions
fig, (ax1, ax2) = plt.subplots(
    2, 1, figsize=(10, 6), gridspec_kw={"height_ratios": [3, 2]}
)

# Line plot
ax1.fill_between(x_range, kde_city_A(x_range), color="#a1dab4", alpha=0.6)
ax1.fill_between(x_range, kde_city_B(x_range), color="#41b6c4", alpha=0.6)
ax1.fill_between(x_range, kde_city_C(x_range), color="#225ea8", alpha=0.6)
ax1.plot(x_range, kde_city_A(x_range), label=labels[0], color="#006d2c", linestyle='-', linewidth=2)
ax1.plot(x_range, kde_city_B(x_range), label=labels[1], color="#238b45", linestyle='--', linewidth=2)
ax1.plot(x_range, kde_city_C(x_range), label=labels[2], color="#084081", linestyle='-.', linewidth=2)
ax1.legend(title=title, loc="upper right")
ax1.set_xticks([])
ax1.set_yticks([])

# Box plot
box = ax2.boxplot(
    [city_A, city_B, city_C], vert=False, patch_artist=True, medianprops={"color": "black"}
)
colors = ["#a1dab4", "#41b6c4", "#225ea8"]
for patch, color in zip(box["boxes"], colors):
    patch.set_facecolor(color)

ax2.set_xlabel(xlabel)
ax2.set_yticks([])
ax2.set_xlim(0, 200)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_91.pdf", bbox_inches="tight")

