
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(42)
# Generate data for weather stats
temperature_data = np.random.normal(20, 5, 1000)
humidity_data = np.random.normal(60, 15, 1000)
wind_speed_data = np.random.normal(10, 3, 1000)
precipitation_data = np.random.normal(5, 2, 1000)
titles = ["Temperature (°C)", "Humidity (%)", "Wind Speed (km/h)", "Precipitation (mm)"]
xlabels = [
    "Daily Temperature (°C)",
    "Daily Humidity (%)",
    "Daily Wind Speed (km/h)",
    "Daily Precipitation (mm)",
]
ylabels = ["Probability", "Probability", "Probability", "Probability"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size
plt.figure(figsize=(10, 8))

# Define the subplot grid with reduced space between subplots
grid = plt.GridSpec(2, 2, wspace=0.4, hspace=0.5)

# Temperature subplot
ax_temperature = plt.subplot(grid[0, 0])
ax_temperature.hist(
    temperature_data, bins=20, color="#2171b5", edgecolor="black", density=True, linewidth=1
)
ax_temperature.plot(
    np.sort(temperature_data),
    norm.pdf(np.sort(temperature_data), np.mean(temperature_data), np.std(temperature_data)),
    color="#fdae61",
)
ax_temperature.set_title(titles[0])
ax_temperature.set_xlabel(xlabels[0])
ax_temperature.set_ylabel(ylabels[0])
ax_temperature.set_ylim(0, 0.090)
ax_temperature.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(temperature_data):.2f}$\n$\sigma = {np.std(temperature_data):.2f}$",
    transform=ax_temperature.transAxes,
    fontsize=9,
)

# Humidity subplot
ax_humidity = plt.subplot(grid[0, 1])
ax_humidity.hist(
    humidity_data,
    bins=20,
    color="#e31a1c",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_humidity.plot(
    np.sort(humidity_data),
    norm.pdf(np.sort(humidity_data), np.mean(humidity_data), np.std(humidity_data)),
    color="#fdae61",
)
ax_humidity.set_title(titles[1])
ax_humidity.set_xlabel(xlabels[1])
ax_humidity.set_ylabel(ylabels[1])
ax_humidity.set_ylim(0, 0.030)
ax_humidity.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(humidity_data):.2f}$\n$\sigma = {np.std(humidity_data):.2f}$",
    transform=ax_humidity.transAxes,
    fontsize=9,
)

# Wind Speed subplot
ax_wind_speed = plt.subplot(grid[1, 0])
ax_wind_speed.hist(
    wind_speed_data,
    bins=20,
    color="#33a02c",
    edgecolor="black",
    density=True,
    linewidth=1,
)
ax_wind_speed.plot(
    np.sort(wind_speed_data),
    norm.pdf(np.sort(wind_speed_data), np.mean(wind_speed_data), np.std(wind_speed_data)),
    color="#fdae61",
)
ax_wind_speed.set_title(titles[2])
ax_wind_speed.set_xlabel(xlabels[2])
ax_wind_speed.set_ylabel(ylabels[2])
ax_wind_speed.set_ylim(0, 0.150)
ax_wind_speed.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(wind_speed_data):.2f}$\n$\sigma = {np.std(wind_speed_data):.2f}$",
    transform=ax_wind_speed.transAxes,
    fontsize=9,
)

# Precipitation subplot
ax_precipitation = plt.subplot(grid[1, 1])
ax_precipitation.hist(
    precipitation_data, bins=20, color="#ff7f00", edgecolor="black", density=True, linewidth=1
)
ax_precipitation.plot(
    np.sort(precipitation_data),
    norm.pdf(np.sort(precipitation_data), np.mean(precipitation_data), np.std(precipitation_data)),
    color="#fdae61",
)
ax_precipitation.set_title(titles[3])
ax_precipitation.set_xlabel(xlabels[3])
ax_precipitation.set_ylabel(ylabels[3])
ax_precipitation.set_ylim(0, 0.250)
ax_precipitation.text(
    0.7,
    0.8,
    f"$\mu = {np.mean(precipitation_data):.2f}$\n$\sigma = {np.std(precipitation_data):.2f}$",
    transform=ax_precipitation.transAxes,
    fontsize=9,
)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_94.pdf", bbox_inches="tight")
