
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt
from scipy.stats import norm

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)
# Define the new data for each subplot using random numbers and normal distribution
temperature_data = np.random.normal(15, 5, 1000)
humidity_data = np.random.normal(50, 15, 1000)
co2_data = np.random.normal(400, 40, 1000)
rainfall_data = np.random.normal(100, 50, 1000)
titles = ["Temperature", "Humidity", "CO2 Levels", "Rainfall"]
xlabels = ["Temperature (°C)", "Humidity (%)", "CO2 Levels (ppm)", "Rainfall (mm)"]
ylabels = ["Frequency", "Frequency", "Frequency", "Frequency"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set the figure size to a more readable size for presentation
plt.figure(figsize=(12, 10))

# Define the subplot grid with reduced space between subplots
grid = plt.GridSpec(2, 2, wspace=0.4, hspace=0.5)

# Temperature subplot
ax_temperature = plt.subplot(grid[0, 0])
ax_temperature.hist(temperature_data, bins=20, color="#ff6f61", edgecolor="black", density=True, linewidth=1)
ax_temperature.plot(np.sort(temperature_data), norm.pdf(np.sort(temperature_data), np.mean(temperature_data), np.std(temperature_data)),
              color="#4285f4", linewidth=2)
ax_temperature.set_title(titles[0])
ax_temperature.set_xlabel(xlabels[0])
ax_temperature.set_ylabel(ylabels[0])
ax_temperature.text(0.7, 0.8, f"$\mu = {np.mean(temperature_data):.2f}$\n$\sigma = {np.std(temperature_data):.2f}$",
              transform=ax_temperature.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# Humidity subplot
ax_humidity = plt.subplot(grid[0, 1])
ax_humidity.hist(humidity_data, bins=20, color="#ffafc9", edgecolor="black", density=True, linewidth=1)
ax_humidity.plot(np.sort(humidity_data), norm.pdf(np.sort(humidity_data), np.mean(humidity_data), np.std(humidity_data)),
                 color="#34a853", linewidth=2)
ax_humidity.set_title(titles[1])
ax_humidity.set_xlabel(xlabels[1])
ax_humidity.set_ylabel(ylabels[1])
ax_humidity.text(0.7, 0.8, f"$\mu = {np.mean(humidity_data):.2f}$\n$\sigma = {np.std(humidity_data):.2f}$",
                 transform=ax_humidity.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# CO2 Levels subplot
ax_co2 = plt.subplot(grid[1, 0])
ax_co2.hist(co2_data, bins=20, color="#b6d7a8", edgecolor="black", density=True, linewidth=1)
ax_co2.plot(np.sort(co2_data), norm.pdf(np.sort(co2_data), np.mean(co2_data), np.std(co2_data)),
               color="#fbbc05", linewidth=2)
ax_co2.set_title(titles[2])
ax_co2.set_xlabel(xlabels[2])
ax_co2.set_ylabel(ylabels[2])
ax_co2.text(0.7, 0.8, f"$\mu = {np.mean(co2_data):.2f}$\n$\sigma = {np.std(co2_data):.2f}$",
               transform=ax_co2.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# Rainfall subplot
ax_rainfall = plt.subplot(grid[1, 1])
ax_rainfall.hist(rainfall_data, bins=20, color="#d9ead3", edgecolor="black", density=True, linewidth=1)
ax_rainfall.plot(np.sort(rainfall_data), norm.pdf(np.sort(rainfall_data), np.mean(rainfall_data), np.std(rainfall_data)),
              color="#ea4335", linewidth=2)
ax_rainfall.set_title(titles[3])
ax_rainfall.set_xlabel(xlabels[3])
ax_rainfall.set_ylabel(ylabels[3])
ax_rainfall.text(0.7, 0.8, f"$\mu = {np.mean(rainfall_data):.2f}$\n$\sigma = {np.std(rainfall_data):.2f}$",
              transform=ax_rainfall.transAxes, fontsize=9, bbox=dict(facecolor='white', edgecolor='gray', boxstyle='round,pad=0.5'))

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("CB_96.pdf", bbox_inches="tight")
