
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Data for plotting
x = [50, 70, 90, 110, 130]
y = [10, 25, 35, 45, 60]
x2 = [150]
y2 = [75]

# Labels and Plot Types
label_Population_Visitor = "Visitor Counts"
label_Highlight = "Peak Tourist Spot"
ax1_txt = [
    "10M\nCountry A",
    "25M\nCountry B",
    "35M\nCountry C",
    "45M\nCountry D",
    "60M\nCountry E",
]
ax2_txt = "75M\nTop Spot"

# Axes Limits and Labels
xlabel_value = "Country Populations (M)"
ylabel_value = "Visitor Counts (M)"
xticklabels1 = [str(num) for num in x]
ylim_values = [0, 80]
yticks_values = [0, 20, 40, 60, 80]
xlim_values = [0, 160]
xticks_values = [0, 50, 100, 150]
xticklabels2 = ["0", "50", "100", "150"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(6, 8))

# Plot the data
ax.plot(x, y, 'o--', color='purple', label=label_Population_Visitor, linewidth=2, markersize=8)
ax.plot(x2, y2, 'v', color='green', markersize=10, label=label_Highlight)

# Annotate the points
for i, txt in enumerate(ax1_txt):
    ax.annotate(
        txt,
        (x[i], y[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
        color='black'
    )
ax.annotate(
    ax2_txt,
    (x2[0], y2[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title("Country Populations vs. Visitor Counts", fontsize=14)

# Set the legend
legend = ax.legend(fontsize=12)

# Adjust x-axis labels
ax.set_xticks(x)
ax.set_xticklabels(xticklabels1, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_98.pdf", bbox_inches="tight")
