
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# Generate new data for average daily steps taken
days = [0, 10, 20, 30, 40, 50]
age_group_20_30 = [8000, 8500, 9000, 8700, 9200, 9500]
age_group_50_60 = [6000, 6200, 6500, 6400, 6800, 7000]

# Single data point for age group 50-60
important_day = [30]
important_steps = [6400]

# Labels and Plot Types
label_age_group_20_30 = "Age Group 20-30"
label_age_group_50_60 = "Age Group 50-60"
annotations_age_group_20_30 = [
    "8000\nStart",
    "8500\nRise",
    "9000\nPeak",
    "8700\nDrop",
    "9200\nClimb",
    "9500\nEnd",
]
annotation_age_group_50_60 = "6400\nSignificant Drop"

# Axes Limits and Labels
xlabel_value = "Days"
ylabel_value = "Average Daily Steps"
xticklabels1 = [str(day) for day in days]
ylim_values = [5000, 10000]
yticks_values = np.arange(5000, 10001, 500)
xlim_values = [-5, 55]
xticks_values = [0, 10, 20, 30, 40, 50]
xticklabels2 = ["0", "10", "20", "30", "40", "50"]
title="Daily Steps Analysis by Age Group"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the figure and axis
fig, ax = plt.subplots(figsize=(8, 6))

# Plot the data
ax.plot(days, age_group_20_30, "g^-", label=label_age_group_20_30, linewidth=2, markersize=8)
ax.plot(important_day, important_steps, "r*--", markersize=12, label=label_age_group_50_60)

# Annotate the points for Age Group 20-30
for i, txt in enumerate(annotations_age_group_20_30):
    ax.annotate(
        txt,
        (days[i], age_group_20_30[i]),
        textcoords="offset points",
        xytext=(0, 5),
        ha="center",
        fontsize=10,
    )
# Annotate the single important point for Age Group 50-60
ax.annotate(
    annotation_age_group_50_60,
    (important_day[0], important_steps[0]),
    textcoords="offset points",
    xytext=(0, 5),
    ha="center",
    color="black",
    fontsize=10,
)

# Set labels and title
ax.set_xlabel(xlabel_value, fontsize=12)
ax.set_ylabel(ylabel_value, fontsize=12)
ax.set_title(title, fontsize=14)

# Set the legend
legend = ax.legend(fontsize=10)

# Adjust x-axis labels
ax.set_xticks(xticks_values)
ax.set_xticklabels(xticklabels2, ha="center")
ax.set_ylim(ylim_values)
ax.set_yticks(yticks_values)
ax.set_xlim(xlim_values)

# ===================
# Part 4: Saving Output
# ===================
# Show the plot with tight layout
plt.tight_layout()
plt.savefig("CB_99.pdf", bbox_inches="tight")
