
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np
# New Data for Legal Domain
np.random.seed(42)
bubble_sizes = {100: 600, 80: 500, 60: 450, 40: 400, 20: 300, 10: 150, 0: 20}
colors = {0: "#66c2a5", 1: "#fc8d62", 2: "#8da0cb", 3: "#e78ac3"}
label2idx = {"Case Wins": 0, "Case Losses": 1, "Pending Cases": 2, "Settled Cases": 3}
idx2label = {v: k for k, v in label2idx.items()}

data = {
    "District A": {
        "Case Wins": [100, 80, 60, 40],
        "Case Losses": [40, 60, 80, 100],
        "Pending Cases": [60, 40, 20, 10],
        "Settled Cases": [20, 40, 60, 80],
    },
    "District B": {
        "Case Wins": [10, 20, 40, 80],
        "Case Losses": [80, 60, 40, 20],
        "Pending Cases": [20, 60, 10, 40],
        "Settled Cases": [80, 40, 20, 60],
    },
    "District C": {
        "Case Wins": [60, 60, 40, 20],
        "Case Losses": [40, 20, 10, 80],
        "Pending Cases": [40, 60, 80, 10],
        "Settled Cases": [20, 80, 60, 40],
    },
    "District D": {
        "Case Wins": [20, 10, 40, 60],
        "Case Losses": [60, 40, 20, 80],
        "Pending Cases": [10, 40, 60, 20],
        "Settled Cases": [40, 20, 80, 10],
    },
}

xlabel = "Cases"
legend_title = "Legal Metrics"
output_filename = "HR_27_1.pdf"

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Create the subplots
fig, axs = plt.subplots(1, 4, figsize=(12, 4), sharey=True)

# Loop through each subplot and plot the data
for i, (title, metrics) in enumerate(data.items()):
    ax = axs[i % 4]
    ax.set_title(title)

    for metric, values in metrics.items():
        ax.scatter(
            x=range(len(values)),
            y=[label2idx[metric]] * len(values),
            s=[bubble_sizes[_] for _ in values],
            c=colors[label2idx[metric]],
            label=metric,
        )
        for j, v in enumerate(values):
            ax.text(j, label2idx[metric], str(v), ha="center", va="center")
    ax.set_xticks(range(len(values)))
    ax.set_xticklabels([f"{i}" for i in range(len(values))])
    ax.set_xlim(-0.5, len(values) - 0.5)
    ax.set_ylim(-0.5, len(label2idx) - 0.5)
    ax.set_yticks([])
    ax.set_xlabel(xlabel)

# Add the legend
handles, labels = axs[0].get_legend_handles_labels()
fig.legend(
    handles,
    labels,
    loc="lower center",
    ncol=4,
    markerscale=0.5,
    fontsize="small",
    bbox_to_anchor=(0.5, -0.1),
    title=legend_title,
    title_fontsize="small",
)

# ===================
# Part 4: Saving Output
# ===================
# Adjust the layout and save the plot
plt.tight_layout()
plt.savefig("HR_27.pdf", bbox_inches="tight")
