
# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Sample data for reproduction
time_periods = np.arange(14)
concept_freq_cognitive_load = np.array(
    [300, 320, 340, 310] + sorted(list(np.random.randint(200, 400, 10)))
)
concept_freq_emotional_regulation = np.array(
    [310, 330, 350, 320] + sorted(list(np.random.randint(200, 400, 10)))
)
additional_data = [sorted(np.random.randint(50, 200, 10), reverse=True) for i in range(2)]
# Creating an array of time periods to adjust spacing for the bars
adjusted_periods = np.array(time_periods, dtype=float)
# Adjust spacing for purple and the three bars before it
adjusted_periods[3] += 0.5
# Adjust spacing between the green/brown bars and the others
adjusted_periods[4:] += 4
title = "Cognitive Load Frequency"
xlabel = "Time Periods"
ylabel = "Frequency"
ylim = [0, 420]
axhline = 400

title2 = "Emotional Regulation Frequency"
xlabel2 = "Time Periods"
ylabel2 = "Frequency"
ylim2 = [0, 420]
axhline2 = 400
xticks = adjusted_periods[4:]
xtickslabel = np.arange(0, 10)

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Set figure size to match original image dimensions

earthy_colors = ['#8c6d31', '#d9b180', '#705e34', 'brown']
serene_colors = [plt.cm.Greens(i) for i in np.linspace(0.7, 0.3, 10)]
tranquil_colors = [plt.cm.Blues(i) for i in np.linspace(0.8, 0.4, 10)]
plt.figure(figsize=(10, 4))

# Subplot 1: Cognitive Load Frequency
plt.subplot(1, 2, 1)
plt.bar(
    adjusted_periods[:4],
    concept_freq_cognitive_load[:4],
    color=earthy_colors,
)
plt.bar(adjusted_periods[4:], concept_freq_cognitive_load[4:], color=serene_colors)
plt.bar(adjusted_periods[4:], additional_data[0], width=0.5, color=tranquil_colors)
plt.title(title, y=-0.3)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline, linestyle="dotted", color="gray")

# Subplot 2: Emotional Regulation Frequency
plt.subplot(1, 2, 2)
plt.bar(
    adjusted_periods[:4],
    concept_freq_emotional_regulation[:4],
    color=earthy_colors,
)
plt.bar(adjusted_periods[4:], concept_freq_emotional_regulation[4:], color=serene_colors)
plt.bar(adjusted_periods[4:], additional_data[1], width=0.5, color=tranquil_colors)
plt.title(title2, y=-0.3)
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.ylim(ylim2)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline2, linestyle="dotted", color="gray")

# ===================
# Part 4: Saving Output
# ===================
# Adjust layout and display the plot
plt.tight_layout()
plt.savefig("HR_32.pdf", bbox_inches="tight")
