

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

np.random.seed(0)

# Generate data for Air Quality Index (AQI)
months = np.arange(12)
city1_aqi = np.array(
    [50, 55, 60, 65] + sorted(list(np.random.randint(40, 80, 8)))
)
city2_aqi = np.array(
    [45, 50, 55, 60] + sorted(list(np.random.randint(35, 75, 8)))
)
pollution_reduction = [sorted(np.random.randint(5, 20, 8), reverse=True) for i in range(2)]
adjusted_months = np.array(months, dtype=float)
adjusted_months[3] += 0.5
adjusted_months[4:] += 4

title = "City 1 AQI Over Months"
xlabel = "Months"
ylabel = "Air Quality Index (AQI)"
ylim = [0, 90]
axhline = 75

title2 = "City 2 AQI Over Months"
xlabel2 = "Months"
ylabel2 = "Air Quality Index (AQI)"
ylim2 = [0, 90]
axhline2 = 75
xticks = adjusted_months[4:]
xtickslabel = np.arange(1, 9)

# Colors for the bars
city1_colors = [plt.cm.Reds(i) for i in np.linspace(0.8, 0.5, 8)]
city2_colors = [plt.cm.Blues(i) for i in np.linspace(0.3, 0.7, 8)]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
plt.figure(figsize=(10, 4))

# Subplot 1: City 1 AQI
plt.subplot(1, 2, 1)
plt.bar(adjusted_months[:4], city1_aqi[:4], color=["#FFA07A", "#FFD700", "#FF4500", "orange"])
plt.bar(adjusted_months[4:], city1_aqi[4:], color=city1_colors)
plt.bar(adjusted_months[4:], pollution_reduction[0], width=0.5, color=city2_colors)
plt.title(title, y=-0.3)
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.ylim(ylim)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline, linestyle="dotted", color="black")
plt.legend(["Pollution Reduction", "City 1 AQI"], loc="upper right")

# Subplot 2: City 2 AQI
plt.subplot(1, 2, 2)
plt.bar(adjusted_months[:4], city2_aqi[:4], color=["#7FFFD4", "#00BFFF", "#1E90FF", "blue"])
plt.bar(adjusted_months[4:], city2_aqi[4:], color=city2_colors)
plt.bar(adjusted_months[4:], pollution_reduction[1], width=0.5, color=city1_colors)
plt.title(title2, y=-0.3)
plt.xlabel(xlabel2)
plt.ylabel(ylabel2)
plt.ylim(ylim2)
plt.xticks(xticks, xtickslabel)
plt.axhline(axhline2, linestyle="dotted", color="black")
plt.legend(["Pollution Reduction", "City 2 AQI"], loc="upper right")

# ===================
# Part 4: Saving Output
# ===================
plt.tight_layout()
plt.savefig("HR_33.pdf", bbox_inches="tight")

