

# ===================
# Part 1: Importing Libraries
# ===================
import matplotlib.pyplot as plt

# ===================
# Part 2: Data Preparation
# ===================
import numpy as np

# Seed for reproducibility
np.random.seed(42)

# Generate time values (simulating days in a financial quarter)
time = np.arange(1, 91)

# Simulate stock prices with a random walk pattern
stock_prices = 100 + np.cumsum(np.random.normal(0, 1, len(time)))

# Normalize stock prices for color mapping
normalized_stock_prices = (stock_prices - np.min(stock_prices)) / (np.max(stock_prices) - np.min(stock_prices))

# Text parameters
xlabel = "Day of Quarter"
ylabel = "Stock Price ($)"
title = "Simulated Stock Prices Over a Financial Quarter"
label =["Average Stock Price", "Mid-Quarter"]

# ===================
# Part 3: Plot Configuration and Rendering
# ===================
# Creating a custom linear color map from light green to dark blue based on these normalized stock prices
colors = [plt.cm.BuGn_r(price) for price in normalized_stock_prices]

# Set the figure size
plt.figure(figsize=(10, 6))

# Plot the points with a line
plt.plot(time, stock_prices, color="lightgray", linewidth=1, linestyle="--")
plt.scatter(time, stock_prices, c=colors, s=50, edgecolor="black")

# Set axis labels and title
plt.xlabel(xlabel)
plt.ylabel(ylabel)
plt.title(title)

# Add axis lines
plt.axhline(stock_prices.mean(), color="gray", linewidth=0.5, linestyle="--", label=label[0])
plt.axvline(45, color="gray", linewidth=0.5, linestyle="--", label=label[1])

# Add grid for better readability
plt.grid(True, which="both", linestyle="--", linewidth=0.5)

# Add legend
plt.legend()

# ===================
# Part 4: Saving Output
# ===================
# Display the plot with tight layout to minimize white space
plt.tight_layout()
plt.savefig("HR_38.pdf", bbox_inches="tight")

